__author__ = 'Konstantin_Brand'

from pylab import *
import DCTo
import DSTo

def optimfuncDSTDCTL1randcomb(x):
    ''' function to minimize, dim. of x is 32
    x is the sparse vector of unknown (DCT and DST) doefficients.
    Example of matching pursiut and random sampling, overcomplete transform with DCT and DST and L1 (abs) norm.
    Args:    x: (ndarray)
    Return:  optimfuncDSTDCTL1randcomb: (ndarray)
    '''
    # Overcomplete transform:
    t = hstack((DCTo(16), DSTo(16)))
    # Signal Example:
    s = cos(pi/16*(arange(16))*12.5)
    # Initialize random generator:
    seed([1, 2, 3])
    # random measurement matrix PHI, with 5 measurements per non-zero coefficient (2 coeff):
    PHI = rand(10, 16)
    #Lagrange optimization, with distance measure only for random samples:
    optimfuncDSTDCTL1randcomb = sum(((PHI*s)-(PHI*dot(t, x)))**2)+sum(abs(x))
    return optimfuncDSTDCTL1randcomb
