__author__ = 'Konstantin_Brand', 'Gerald Schuller'

from pylab import *

from DCTo import *
from DSTo import *

def optimfuncDSTDCTL1(x):
    ''' function to minimize, dim. of x is 32.
    Example of matching pursiut, overcomplete transform with DCT and DST and L1 (abs) norm.
    Args:  x: (ndarray)
    Return: optimfuncDSTDCTL1 : (ndarray)
    '''
    # Overcomplete transform:
    t = hstack((DCToMatrix(16), DSToMatrix(16)))
    # Signal Example:
    s = cos(pi/16*(arange(16))*12.5)
    # Lagrange optimization:
    return sum((s-dot(t, x))**2)+sum(abs(x))


