# -*- coding: utf-8 -*-
__author__ = 'S.I. Mimilakis'
__copyright__ = 'MacSeNet'
from keras.models import Sequential
from keras.layers.core import Dense, Activation
import numpy as np

def generate_dummy_data():
    #Method to generate some artificial data in an numpy array form in order to fit the network.
    #:return: X, Y numpy arrays used for training
    X = np.array([[0.5,1.,0], [0.2,0.7,0.3], [0.5,0,1.], [0,0,1.]])
    Y = np.array([[1], [0], [1], [1]])
    return X, Y

def generate_model():
    #    Method to construct a fully connected neural network using keras and theano.
    #    :return: Trainable object
    # Define the model. Can be sequential or graph
    model = Sequential()
    model.add(Dense(output_dim = 4, input_dim = 3, init="normal"))
    model.add(Activation("sigmoid"))
    model.add(Dense(output_dim = 1, input_dim = 3,  init="normal"))
    model.add(Activation("sigmoid"))
    # Compile appropriate theano functions
    model.compile(loss='mse', optimizer='sgd')
    return model

if __name__ == '__main__':
    #   Demonstration on using the code.
    X, Y = generate_dummy_data() # Acquire Training Dataset
    model = generate_model()     # Compile an neural net
    model.fit(X, Y, nb_epoch=100, batch_size=4)    
    model.predict(X) # Make Predictions
    model.save_weights('weights.hdf5') #save weights to file

