/*-----_----_-------------------------_------_----------_----_----------_
  __ _(_)__| |___ ___   _ __  ___  __| |__ _| | __ __ _(_)__| |__ _ ___| |_ 
  \ V / / _` / -_) _ \ | '  \/ _ \/ _` / _` | | \ V  V / / _` / _` / -_)  _|
   \_/|_\__,_\___\___/ |_|_|_\___/\__,_\__,_|_|  \_/\_/|_\__,_\__, \___|\__|
--------------------------------------------------------------|___/-----  
  #HTML should look like this:
  <button id='video_modal_button'>Show Modal</button>
  <script>var video_modal_widget = new Video_Modal_Widget('video_modal_button', 'path/to/video.mp4')</script>
----------------------------------------------------------------------*/

//PUBLIC
/*--------------------------------------------------------------------*/
function Video_Modal_Widget(button_id, video_path)
{
  this.open_modal_button = document.getElementById(button_id);
  this.video_modal_div = document.createElement("DIV");
  this.video_modal_div.style.display           = "none";
  this.video_modal_div.style.position          = "fixed";
  this.video_modal_div.style.zIndex            = "1";
  this.video_modal_div.style.left              = "0px";
  this.video_modal_div.style.top               = "0px";
  this.video_modal_div.style.width             = "100%";
  this.video_modal_div.style.height            = "100%";
  this.video_modal_div.style.overflow          = "auto";
  this.video_modal_div.style.backgroundColor   = "rgba(0, 0, 0, 0.4)";
  
  this.modal_content_div = document.createElement("DIV");
  this.modal_content_div.style.backgroundColor = "#fefefe";
  this.modal_content_div.style.position        = "absolute";
  this.modal_content_div.style.top             = "0px";
  this.modal_content_div.style.left            = "0px";
  this.modal_content_div.style.width           = "100%";
  this.modal_content_div.style.height          = "100%";
  this.modal_content_div.style.textAlign       = "center";
  this.modal_content_div.style.display         = "block";
  
  this.modal_video = document.createElement("VIDEO");
  this.modal_video.src                         = video_path;
  this.modal_video.style.position              = "absolute"
  this.modal_video.style.left                  = "0px"
  this.modal_video.style.top                   = "0px"
  this.modal_video.style.width                 = "100%"
  this.modal_video.style.height                = "100%"
  this.modal_video.style.backgroundColor       = "black";
  
  this.close_modal_button = document.createElement("DIV");
  this.close_modal_button.style.color          = "#888";
  this.close_modal_button.style.fontSize       = "28px";
  this.close_modal_button.style.fontWeight     = "bold";
  this.close_modal_button.style.position       = "relative";
  this.close_modal_button.style.backgroundColor= "black";
  this.close_modal_button.style.cursor         = "pointer";
  this.close_modal_button.innerHTML            = "DISMISS";
  //todo: make hover and focus white, make it look clickable for
  //devices with no hover / click
  //also, the button will cover the top of the video in landscape mode
  
  this.modal_content_div.appendChild(this.modal_video       );
  this.modal_content_div.appendChild(this.close_modal_button);
  this.video_modal_div.appendChild  (this.modal_content_div );
  document.body.appendChild         (this.video_modal_div   );
  
  this.close_modal_button.onclick = this.hide_modal.bind(this);
  this.open_modal_button.onclick  = this.show_modal.bind(this);
}

//PUBLIC
/*--------------------------------------------------------------------*/
Video_Modal_Widget.prototype.show_modal = function()
{
  this.video_modal_div.style.display = "block";
  this.modal_video.play();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Video_Modal_Widget.prototype.hide_modal = function()
{
  this.video_modal_div.style.display = "none";
  this.modal_video.pause();
  this.modal_video.currentTime = 0;
}

//PUBLIC
/*--------------------------------------------------------------------*/
Video_Modal_Widget.prototype.set_video = function(video_path)
{
  
  this.modal_video.src = video_path;
  this.modal_video.load();
}