/*-_----------------------------------_------------_----_------ ---_----
  | |_ _ _ __ _ _ _  ____ __  ___ _ _| |_  __ __ _(_)__| |__ _ ___| |_ 
  |  _| '_/ _` | ' \(_-< '_ \/ _ \ '_|  _| \ V  V / / _` / _` / -_)  _|
   \__|_| \__,_|_||_/__/ .__/\___/_|  \__|  \_/\_/|_\__,_\__, \___|\__|
-----------------------|_|-------------------------------|___/----------
  #HTML should look like this:
  
  <script src="api/Inside-Coach-API.js"></script> 
  <script src="widgets/transport/widget.js"></script> 
  <span id="transport_widget"></span>
  <script>var transport_widget = new Transport_Widget("$IC, transport_widget")</script>
              
----------------------------------------------------------------------*/

//Transport_Widget.action    = "http://localhost:3000/user_data.php";
Transport_Widget.action    = "http://api.insidecoach.net/user_data.php";

//PUBLIC
/*--------------------------------------------------------------------*/
function Transport_Widget(IC, span_id, path_to_widgets)
{
  var button_size = 46;
  
  //PUBLIC (null for the ball, or an object containing valid, uncompressed sensor data)
  this.input_source                      = null;
  this.IC                                = IC;
  
  //PRIVATE
  this.span                              = document.getElementById(span_id);
  this.rewind_button                     = this.create_button("rewind.png", path_to_widgets, button_size);
  this.rewind_button.onclick             = this.rewind.bind(this);
  this.play_button                       = this.create_button("play.png", path_to_widgets, button_size);
  this.play_button.onclick               = this.play.bind(this);
  this.stop_button                       = this.create_button("stop.png", path_to_widgets, button_size);
  this.stop_button.onclick               = this.stop.bind(this);
  this.record_button                     = this.create_button("record.png", path_to_widgets, button_size);
  this.record_button.onclick             = this.toggle_record.bind(this);
  this.timer_table = document.createElement("TABLE");
  this.table_row                         = this.timer_table.insertRow(0);
  this.record_timer_minutes              = (this.table_row.insertCell(0));
  this.record_timer_colon                = (this.table_row.insertCell(1));
  this.record_timer_seconds              = (this.table_row.insertCell(2));
  this.record_timer_minutes.innerHTML    = "0";
  this.record_timer_colon.innerHTML      = ":";
  this.record_timer_seconds.innerHTML    = "00";  
  
  this.timer_table.style.width           = "auto";
  this.timer_table.style.display         = "inline-block";
  this.timer_table.style.borderRadius    = "4px";
  this.timer_table.style.padding         = "0px";
  this.timer_table.style.marginLeft      = "3px";
  this.timer_table.style.fontFamily      = "monospace";
  this.timer_table.style.height          = button_size + "px";
  this.timer_table.style.fontSize        = "30px";
  this.timer_table.style.color           = "black";
  this.timer_table.style.verticalAlign   = "top";
  this.init_timer(false);
   
  this.input_source_button               = document.createElement("BUTTON");
  this.input_source_button.onclick       = this.show_input_source_modal.bind(this);
  this.input_source_button.innerHTML     = 'Input Source: Ball';
  
  
  this.span.appendChild(this.rewind_button);
  this.span.appendChild(this.stop_button  );
  this.span.appendChild(this.play_button  );
  this.span.appendChild(this.record_button);
  this.span.appendChild(this.timer_table  );
  this.span.appendChild(this.input_source_button);
  
  /* save sensor data modal */
  this.save_data_content                 = document.createElement("DIV");
  this.save_data_modal                   = this.create_modal(this.save_data_content, this.hide_save_data_modal.bind(this), "300px");
  var e                                  = document.createElement("H2");
  e.innerHTML                            = "Save Recorded Data";
  var f                                  = document.createElement("H4");
  f.innerHTML                            = "(you must be connected to the internet)";
  this.save_data_content.appendChild(e);
  this.save_data_content.appendChild(f);
  
  this.save_data_form                    = document.createElement("FORM");  
  this.save_data_form.innerHTML          = 
    "description: (optional)<br>" +
    "<textarea rows='4' cols='30' name='description' style='resize:vertical'></textarea><br>";
  this.save_data_button = document.createElement("BUTTON");
  this.save_data_button.onclick = this.submit_save_data_form.bind(this);
  this.save_data_button.innerHTML = 'save';
  this.save_data_form.appendChild(this.save_data_button);  
  this.save_data_content.appendChild(this.save_data_form);
  
  /* input source modal */
  this.input_source_content              = document.createElement("DIV");
  this.input_source_modal                = this.create_modal(this.input_source_content, this.hide_input_source_modal.bind(this),  "800px");
  this.input_source_table                = document.createElement("TABLE");
  var column_names = ["description", "date", "duration", "delete"];
  var table_html                         =
    "<thead>"                       +
      "<tr style='text-align:left'>";
      for(var i=0; i<column_names.length; i++) 
        table_html += "<th>" + column_names[i] + "</th>" ;
      table_html +=
      "</tr>"                       +
    "</thead>"                      ;
  
  this.input_source_table.innerHTML = table_html;
  this.input_source_table_body = document.createElement("TBODY");
  this.input_source_table.appendChild(this.input_source_table_body);
  this.input_source_table.style.width      = "100%";
  this.input_source_content.appendChild(this.input_source_table);
  
}
  
  
//PRIVATE (appends close button to content)
Transport_Widget.prototype.create_modal = function(content, close_action, max_width)
{
  var modal                     = document.createElement("DIV");
  modal.style.display           = "none";
  modal.style.position          = "fixed";
  //modal.style.zIndex          = "1";
  modal.style.left              = "0";
  modal.style.top               = "0";
  modal.style.width             = "100%";
  modal.style.height            = "100%";
  modal.style.overflow          = "auto";
  modal.style.backgroundColor   = "rgb(0,0,0)";
  modal.style.backgroundColor   = "rgba(0,0,0,0.4)";
  
  var close_button              = document.createElement("SPAN"); 
  close_button.onclick          = close_action;
  close_button.innerHTML        = "&times;";
  close_button.style.color      = "#AAA";
  close_button.style.float      = "right";
  close_button.style.fontSize   = "28px";
  close_button.style.fontWeight = "bold";
  close_button.style.cursor     = "pointer";
  
  content.style.backgroundColor = "#fefefe";
  content.style.margin          = "15% auto";
  content.style.padding         = "20px";
  content.style.border          = "1px solid #888";
  content.style.width           = "80%";
  content.style.textAlign       = "center";
  content.style.maxWidth        = max_width;
  
  content.appendChild(close_button);
  modal.appendChild(content);
  document.body.appendChild(modal);

  return modal;
}

//PUBLIC
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.connect_to_IC = function()
{

}

//PUBLIC
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.disconnect_from_IC = function()
{

}

//PUBLIC
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.rewind = function()
{
  this.IC.rewind_playing_data();
  this.display_timer_value(0);
}
    
    
//PUBLIC
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.stop = function()
{
  this.button_unclick(this.play_button);

  if(this.IC.is_tracking)
    this.IC.stop_tracking();
  else
    this.IC.pause_playing_data();
    
  if(this.IC.recording_is_armed)
    this.stop_record();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.play = function()
{
  if(this.input_source != null)
    this.IC.start_playing_data(this.input_source);
  else
    this.IC.start_tracking();

  this.button_click(this.play_button);
}

//PUBLIC
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.toggle_record = function()
{
  if(!this.IC.recording_is_armed)
    this.start_record();
  else
    this.stop_record();
}

//PUBLIC    
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.stop_record = function()
{
  this.IC.disarm_recording();
  this.button_unclick(this.record_button);
  this.show_save_data_modal();
}

//PUBLIC
/*--------------------------------------------------------------------*/   
Transport_Widget.prototype.start_record = function()
{
  if(this.input_source != null) return;
  this.IC.arm_recording();
  this.button_click(this.record_button);
  if(!this.IC.is_tracking) this.play();   
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.create_button = function(background_image, path_to_widgets, button_size)
{
  var b = document.createElement("DIV");
  //b.style.background     = "url('../widgets/transport/" + background_image + "')";
  b.style.background     = "url('" + path_to_widgets + "transport/" +background_image + "')";
  b.style.backgroundSize = (2*button_size) + "px " + (2*button_size) + "px";
  b.style.width          = button_size + "px";
  b.style.height         = button_size + "px";
  b.style.display        = "inline-block";
  b.style.padding        = "none";
  b.style.marginRight    = "2px";
  b.position_left        = "0%";
  b.position_top         = "0%";
  b.onmouseover          = this.button_mouseover.bind(this, b);
  b.onmouseout           = this.button_mouseout.bind (this, b);
  b.onmouseout();

  return b;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.display_timer_value = function(value)
{
  var secs = value.toFixed(0);
  var mins = Math.floor(secs / 60).toFixed(0);
  secs -= mins*60;
  secs = secs.toFixed(0);
  secs = "00".substr(secs.length) + secs;
  mins = "00".substr(mins.length) + mins;

  this.record_timer_minutes.innerHTML = mins;
  this.record_timer_seconds.innerHTML = secs;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.init_timer = function(for_playback)
{
  var timer = this.timer_table;
  if(for_playback)
    {
      timer.style.border = "1px solid green";
      timer.style.backgroundColor = "#EEFFEE";
      this.IC.onplayback = this.timer_callback.bind(this);
      this.IC.onrecord = null;
    }
  else
    {
      timer.style.border = "1px solid red";
      timer.style.backgroundColor = "#FFEEEE";
      this.IC.onplayback = null;
      this.IC.onrecord = this.timer_callback.bind(this);       
    }  
  this.display_timer_value(0);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.timer_callback = function(e)
{
  if(!e.will_continue)
    {
      if(this.input_source == null)
        this.stop_record();
      else
        this.stop();
    }
  this.display_timer_value(e.running_duration);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.button_mouseover = function(button)
{
  button.position_top = "100%";
  this.button_refresh(button);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.button_mouseout  = function(button)
{
  button.position_top = "0%";
  this.button_refresh(button);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.button_click = function(button)
{
  button.position_left = "100%";
  this.button_refresh(button);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.button_unclick  = function(button)
{
  button.position_left = "0%";
  this.button_refresh(button);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.button_refresh  = function(button)
{
  button.style.backgroundPosition=button.position_left + " " + button.position_top;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.show_save_data_modal = function()
{
  if(this.IC.recorded_data.length > 0)
    {
      //todo: should compress the data here because the user isn't waiting,
      //but on the other hand I don't want to save the data because it is yuge.
      this.save_data_modal.style.display = "block";
    }
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.hide_save_data_modal = function()
{
  this.save_data_modal.style.display = "none";
  this.display_timer_value(0);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.show_input_source_modal = function()
{
  this.input_source_modal.style.display = "block";
  var params = this.get_generic_request_string("list_sensor_data");
  var callback = this.populate_input_source_list.bind(this);
  this.send_server_request(params, callback);

}

/*--------------------------------------------------------------------*/
Transport_Widget.prototype.hide_input_source_modal = function()
{
  this.input_source_modal.style.display = "none";
}


//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.get_generic_request_string = function(action)
{
  return  "action=" + action +
          "&user_id=0" +
          "&username=Mike Krzyzaniak" +
          "&password=api1234" +
          "&game=sole_roll";

}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.send_server_request = function(params, callback)
{
  var http = new XMLHttpRequest();
  http.open("POST", Transport_Widget.action);
  http.setRequestHeader("Content-type", "application/x-www-form-urlencoded"); //todo: how to pass parameters with multipart/form-data
  http.send(params);
  
  if(callback != null)
     http.onload = function(){ callback(http.responseText) };
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.submit_save_data_form = function(event)
{
  event.preventDefault();

  if(this.IC.recorded_data.length > 0)
    {  
      var params = this.get_generic_request_string("save_sensor_data");
      params += "&description=" + this.save_data_form.description.value;
      params += "&saved_data=" + btoa(pako.gzip(JSON.stringify(this.IC.recorded_data), { level:6, to:'string' }) );
      params += "&duration=" + ((this.IC.recorded_data[this.IC.recorded_data.length-1].ms - this.IC.recorded_data[0].ms) * 0.001);
      params += "&uses_bno_calibration=" + (this.IC.recorded_data[0].qw !== undefined);

      this.send_server_request(params, null);
    }
  this.hide_save_data_modal();
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.delete_sensor_data = function(unix_epoch)
{
  var params = this.get_generic_request_string("delete_sensor_data");
  var callback = this.show_input_source_modal.bind(this);
  params += "&unix_epoch=" + unix_epoch;
  this.send_server_request(params, callback);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.populate_input_source_list = function(json_array)
{
  //["description", "date", "duration", "delete"];
  this.input_source_table_body.innerHTML = "";
  var d;
  var row = this.input_source_table_body.insertRow(0);
  (d=row.insertCell(0)).innerHTML = "<a href='#'>Live Input From The Ball</a>";
  d.onclick = this.open_ball_input_source.bind(this);
  (row.insertCell(1)).innerHTML = "&nbsp;";
  (row.insertCell(2)).innerHTML = "&nbsp;";
  (row.insertCell(3)).innerHTML = "&nbsp;";
    
  var a = JSON.parse(json_array);
  var d;
  var i;
  //unix_epoch TEXT, filename TEXT,  user_id TEXT, uses_bno_calibration TEXT, description TEXT, duration TEXT
  for(i=0; i<a.length; i++)
    {
      row = this.input_source_table_body.insertRow(i+1);
      (d=row.insertCell(0)).innerHTML = "<a href='#'>"+a[i][4]+"</a>"; //todo: errors when there is no descriptiion
      d.onclick = this.open_saved_json_input_source.bind(this, parseInt(a[i][0]));
      (row.insertCell(1)).innerHTML = new Date(parseInt(a[i][0]) * 1000);
      (row.insertCell(2)).innerHTML = new Date(a[i][5] * 1000).toISOString().substr(14, 5);
      (d=row.insertCell(3)).innerHTML = "<a href='#' style='color:#A00;font-size:2em;font-weight:bold;text-decoration:none;'>&times;</a>";
      d.onclick = this.delete_sensor_data.bind(this, parseInt(a[i][0]));
    }
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.open_ball_input_source = function()
{
  this.input_source=null;
  this.input_source_button.innerHTML = "Input Source: Ball";
  this.stop();
  this.hide_input_source_modal();
  this.init_timer(false);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.open_saved_json_input_source = function(unix_epoch)
{
  var params = this.get_generic_request_string("get_sensor_data");
  var callback = this.saved_sensor_data_did_load.bind(this);
  params += "&unix_epoch=" + unix_epoch;
  this.send_server_request(params, callback);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Transport_Widget.prototype.saved_sensor_data_did_load = function(data)
{
  //this really shouldn't be necessary
  //todo: what is going on here?
  //the saved data does not have the plusses
  //so they must be getting removed on transmission
  //Hopefully this will be fixed when using multipart/form-data
  data = data.replace(/ /g, '+');
  
  this.input_source = JSON.parse(pako.inflate(atob(data), {to:'string'}));
  this.input_source_button.innerHTML = "Input Source: File";
  this.stop();
  this.hide_input_source_modal();
  this.input_source.innerHTML = "Input Source: File";
  this.init_timer(true);  
}

