/*----------------------------_-------------------------_----------_----
   ____ __  ___ ___ __| |_   | |___  __ _  __ __ _(_)__| |__ _ ___| |_ 
  (_-< '_ \/ -_) -_) _| ' \  | / _ \/ _` | \ V  V / / _` / _` / -_)  _|
  /__/ .__/\___\___\__|_||_| |_\___/\__, |  \_/\_/|_\__,_\__, \___|\__|
-----|_|----------------------------|___/----------------|___/----------   
  #HTML should look like this:
  <div id='speech_log_widget'></div>
  <script>var speech_log_widget = new Speech_Log_Widget('speech_log_widget')</script>
----------------------------------------------------------------------*/

//PUBLIC
/*--------------------------------------------------------------------*/
function Speech_Log_Widget(div_id)
{
  this.message_div = document.getElementById(div_id);
  this.message_div.style.lineHeight = "1.5em";
  this.message_div.style.height = "1.5em";
  this.message_div.style.overflow = "hidden";
  this.message_div.style.text_align = "center";
  this.message_div.style.border = "1px solid black";
  
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Speech_Log_Widget.prototype.init = function()
{
  this.clear();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Speech_Log_Widget.prototype.clear = function()
{
  this.message_div.innerHTML = "";
}

//PUBLIC
/*--------------------------------------------------------------------*/
Speech_Log_Widget.prototype.display = function(message)
{
  this.message_div.innerHTML = message;
}

//PUBLIC
/*--------------------------------------------------------------------*/
Speech_Log_Widget.prototype.display_and_speak = function(message)
{
  window.speechSynthesis.speak(new SpeechSynthesisUtterance(message));
  this.message_div.innerHTML = message;
}
