/*----------------------_--------------------_----_----------_----------
   ___ __ ___ _ _ ___  | |___  __ _  __ __ _(_)__| |__ _ ___| |_ 
  (_-</ _/ _ \ '_/ -_) | / _ \/ _` | \ V  V / / _` / _` / -_)  _|
  /__/\__\___/_| \___| |_\___/\__, |  \_/\_/|_\__,_\__, \___|\__|
------------------------------|___/----------------|___/----------------
  #HTML should look like this:
  <table id="score_log_widget"></canvas>
  <script src="widgets/score_log/widget.js"></script>
  <script>var score_log_widget = new Score_Log_Widget('score_log_widget')</script>
  
  The score log is stored in LocalStorage. The storage name contains the
  game name and the user ID, so one localStorage item per game per user.
  The localStorage contains the past num_rows of data to be displayed
  in the table.
  
  It also contains a queue of rows that are waiting to be synced to the
  inside coach server. Periodically, if it can connect, it will
  sync as many of the rows in the queue as it can, which will be
  stored permenantly in the database there.
----------------------------------------------------------------------*/

//Score_Log_Widget.action = "http://localhost:3000/user_data.php";
Score_Log_Widget.action = "http://api.insidecoach.net/user_data.php";

//PUBLIC
/*--------------------------------------------------------------------*/
function Score_Log_Widget(table_id, user_id, game_name, column_names /* array of column names */, blank_row/*array of values*/)
{
  this.table = document.getElementById(table_id);
  
  var table_html =
    "<thead>"                       +
      "<tr style='text-align:left'>";
      for(var i=0; i<column_names.length; i++) 
        table_html += "<th>" + column_names[i] + "</th>" ;
      table_html +=
      "</tr>"                       +
    "</thead>"                      ;
  this.table.innerHTML = table_html;
  
  this.table_body = document.createElement('TBODY');
  this.table.appendChild(this.table_body);
  this.table.style.width      = "100%";
  this.table.style.fontFamily = "Arial";
  //this.table.style.fontSize = "24pt";
  this.num_rows               = 4;
  //this.data                   = null;
  this.data                   = {server_queue: new Array(), log:new Array()};
  this.game_name              = game_name;
  this.user_id                = user_id;
  this.blank_row              = blank_row;
  this.column_names           = column_names;
  
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.init = function()
{
  this.data = null;
  this.storage_name  = this.game_name + " " + this.user_id;

  if(this.game_name != "")
    this.data = localStorage.getItem(this.storage_name);
  if(this.data != null)
    this.data = JSON.parse(this.data);
  else
    this.data = {server_queue: new Array(), log: new Array()};
    
  this.table_body.innerHTML = "";
  var i, j;
  for(i=0; i<this.num_rows; i++)
    {
      var d = (this.data.log[i] == null);
      var row = this.table_body.insertRow(i);
      for(j=0; j<this.column_names.length; j++)
        (row.insertCell(j)).innerHTML = d ? this.blank_row[j] : this.data.log[i][j];
    }
    
    
  this.table_body.rows[0].style.color = "#00A000";
  this.table_body.rows[0].style.fontWeight = "bold";
  this.sync_log_to_server();
  this.insert_new_first_row();
   
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.clear = function()
{
  localStorage.removeItem(this.game_name);
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.set_game_name = function(name)
{
  this.game_name = name;
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.set_user_id = function(user_id)
{
  this.user_id = user_id;
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.live_update_first_row = function(values /*array*/)
{
  var i;
  
  for(i=0; i<this.column_names.length; i++)
    this.table_body.rows[0].cells[i].innerHTML = this.data.log[0][i] = values[i];
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.commit_first_row = function()
{
  this.data.server_queue.push(this.data.log[0]);
  var s = JSON.stringify(this.data);
  localStorage.setItem(this.storage_name, s);
  
  this.sync_log_to_server();
  this.insert_new_first_row();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.insert_new_first_row = function()
{
  var i;
  this.data.log.unshift(this.blank_row.slice());
  while(this.data.log.length >this.num_rows) this.data.log.pop();
  for(i=this.num_rows-1; i>0; i--)
    this.table_body.rows[i].innerHTML = this.table_body.rows[i-1].innerHTML;
  
  this.live_update_first_row(this.blank_row);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.get_generic_request_string = function(action)
{
  return  "action=" + action +
          "&user_id=" + this.user_id +
          "&username=Mike Krzyzaniak" +
          "&password=asdf1234" +
          "&game=" + this.game_name;

}

//PRIVATE
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.send_server_request = function(params, callback)
{
  var http = new XMLHttpRequest();
  http.open("POST", Score_Log_Widget.action);
  http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
  http.send(params);

  if(callback != null)
    http.onload = function(){ callback(http.responseText) };
}

//PRIVATE
/*--------------------------------------------------------------------*/
//this does one row at at time and waits for response each time
Score_Log_Widget.prototype.sync_log_to_server = function()
{
  if(this.data.server_queue.length > 0)
    {
      var callback = this.server_did_sync_one_row.bind(this);
      var params = this.get_generic_request_string("save_score_data");
      params += "&score_row=" + JSON.stringify(this.data.server_queue[0]);
      //todo: add the UNIX timestamp when the row is committed.
      //currently, the server add the timestamp when it is synced.
      this.send_server_request(params, callback);
    }
}

//PRIVATE
/*--------------------------------------------------------------------*/
Score_Log_Widget.prototype.server_did_sync_one_row = function(response)
{
  if(response == 'OK')
    {
      this.data.server_queue.shift();
      if(this.data.server_queue.length > 0)
        this.sync_log_to_server();
    }
}
