//PUBLIC
/*--------------------------------------------------------------------*/
function Score_Comparison_Widget(canvas_id, dimensions /*array of text labels*/)
{
  this.canvas           = document.getElementById(canvas_id);
  this.context          = this.canvas.getContext('2d');
  this.center_x         = this.canvas.width  * 0.5;
  this.center_y         = this.canvas.height * 0.5;
  this.radius           = Math.min(this.center_x, this.center_y) * 0.7;
  
  this.init(dimensions);
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Comparison_Widget.prototype.init = function(dimensions)
{
  this.dimensions       = dimensions;
  this.clear();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Comparison_Widget.prototype.clear = function()
{
  this.target_score     = null;
  this.my_score         = null;
  this.refresh();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Comparison_Widget.prototype.set_target_score = function(score /*array of floats [0 ~ 1], one for each dimension*/)
{
  this.target_score = score;
  this.refresh();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Score_Comparison_Widget.prototype.set_my_score = function(score /*array of floats [0 ~ 1], one for each dimension*/)
{
  this.my_score = score;
  this.refresh();
}

//PRIVATE
/*--------------------------------------------------------------------*/
Score_Comparison_Widget.prototype.refresh = function()
{
  //white circle background
  this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
  this.context.fillStyle="rgb(255, 255, 255)";
  this.context.beginPath();
  this.context.ellipse(this.center_x, this.center_y, this.radius, this.radius, 0, 0, 2*Math.PI);
  this.context.fill();
  
  var n = this.dimensions.length;
  var theta = 2*Math.PI / n;
  var i;
  
  this.context.save()
  this.context.translate(this.center_x, this.center_y);
  
  //axes
  var font_size = 0.2*this.radius;
  this.context.save        ();
  this.context.strokeStyle="rgb(128, 128, 128)";
  this.context.textAlign    = "center"; 
  //this.context.textBaseline = "middle";
        this.context.fillStyle = "rgb(255, 255, 255)";
      this.context.font = font_size + "px Helvetica";//"px Muli Extrabold";
      
  for(i=0; i<n; i++)
    {
      this.context.beginPath();
      this.context.moveTo(0, 0);
      this.context.lineTo(0, -this.radius);
      this.context.stroke();
      
      
      this.context.fillText(this.dimensions[i], 0, -this.radius - this.radius*0.13);
      
      
      this.context.rotate(theta);
    }
  this.context.restore     ();

  this.draw_blob_with_color("rgba(241, 70, 145, 0.9)", this.target_score);
  this.draw_blob_with_color("rgba(60, 90, 180, 0.8)", this.my_score);
  

  this.context.restore     ();
}

//PRIVATE
// canvas must already translated so center is at origin
/*--------------------------------------------------------------------*/
Score_Comparison_Widget.prototype.draw_blob_with_color = function(color, values)
{
  if(values != null)
    {
      var n = values.length;
      var theta = 2*Math.PI / n;
      this.context.save        ();
      this.context.fillStyle=color;
      this.context.beginPath();
      this.context.moveTo(0, values[0] * -this.radius);
      for(i=1; i<n+1; i++)
        {
          this.context.rotate(theta);
          this.context.lineTo(0, values[i%n] * -this.radius);
        }
      this.context.fill(); 
      this.context.restore     ();
    }  
}
