/*---------_-_-_--------_---------------------------_------------------_      _
   _ _ ___| | | |_(_)__| |__  _ __  __ _ __ _ ___  | |_ ___ _ __  _ __| |__ _| |_ ___ 
  | '_/ _ \ | | / / / _| / / | '_ \/ _` / _` / -_) |  _/ -_) '  \| '_ \ / _` |  _/ -_)
  |_| \___/_|_|_\_\_\__|_\_\ | .__/\__,_\__, \___|  \__\___|_|_|_| .__/_\__,_|\__\___|
-----------------------------|_|--------|___/--------------------|_|----
  #HTML should look like this:

  <!--span id="transport"></span-->
  <span id="ball_status"></li>
  <button type="button" id="reset_button" onclick="template.clear()">RESET</button>
  <button type="button" id="video_modal">VIDEO</button>
  <canvas id="speedometer" width="400" height="400"></canvas>
  <canvas id="ball_position" width="600" height="300" style="width:100%;"></canvas>
  <table id="score_log"></table>
  <div id="speech_log"></div>
  <script>var template = new Rollkick_Page_Template($IC, ball_status, video_modal, VIDEO_PATH, speedometer, ball_position, score_log, speech_log, WDGETS_DIR, PAGE_NAME)</script>
----------------------------------------------------------------------*/


/*--------------------------------------------------------------------*/
function Rollkick_Page_Template(IC, user_id, video_modal_id, speedometer_id, ball_position_id, score_log_id, speech_log_id, widgets_directory)
{
  //this.transport                         = new Transport_Widget    (IC, "transport", "<?php echo $WIDGETS_DIRECTORY ?>");
  //this.ball_status                       = new Ball_Status_Widget  (ball_status_id, widgets_directory);
  this.video_modal                         = new Video_Modal_Widget  (video_modal_id, ""); //set the video src when the page loads
  this.speedometer                         = new Speedometer_Widget  (speedometer_id, "kicks / minute", "kicks", widgets_directory);
  this.ball_position                       = new Ball_Position_Widget(ball_position_id, widgets_directory);
  this.score_log                           = new Score_Log_Widget    (score_log_id, user_id, "", ["KICKS", "K/MIN", "PLAY TIME", "SUCCESS"], [0, 0, 0, "&mdash;"]);
  this.speech_log                          = new Speech_Log_Widget   (speech_log_id);
  this.IC                                  = IC;
  this.timer_interval                      = 200; //milliseconds
  this.timer_value                         = 0;
  this.activity_level                      = 0;
  this.activity_level_decay                = 0.9;
  this.no_activity_stop_timer_duration     = 5000;  //milliseconds
  this.no_activity_reset_timer_duration    = 15000; //milliseconds
  this.no_activity_stop_timer_thresh       = Math.pow(this.activity_level_decay, this.no_activity_stop_timer_duration  / this.timer_interval);
  this.no_activity_reset_timer_thresh      = Math.pow(this.activity_level_decay, this.no_activity_reset_timer_duration / this.timer_interval);
  this.score_stats                         = new OnlineAverage();
  this.is_active                           = false;
  this.will_reset                          = true;
 
  this.timer_thread = null;
  this.clear();
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.page_load = function(name, video_path, speedometer_level_text, speedometer_num_text)
{
  this.video_modal.set_video(video_path);
  this.score_log.set_game_name(name);
  this.IC.onrollkick       = this.onrollkick.bind(this);
  this.IC.onrolling = this.onrolling.bind(this);

  this.clear();
  this.is_active                           = false;
  this.will_reset                          = true;
  this.timer_value                         = 0;
  this.activity_level                      = 0;
  this.timer_run();
  
  this.ball_position.drift_correction = true;
  this.ball_position.num_samples = 22;
  
  this.speedometer.num_text   = speedometer_num_text;
  this.speedometer.level_text = speedometer_level_text;
  "kicks / minute", "kicks", 
  
  this.IC.start_tracking();
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.page_unload = function()
{
  this.IC.stop_tracking();
  this.IC.onrollkick       = null;
  this.IC.onrolling = null;
  this.timer_stop();
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.clear = function()
{
  this.activity_level = 0;
  this.speedometer.set_level(0, false, 0, true);
  this.score_log.live_update_first_row(this.score_log.blank_row);
  this.ball_position.clear();
  this.IC.soft_init();
}
  
/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.active_state_did_change = function(is_active, will_reset)
{
  //activity_indicator.set_level((this.is_active==true) ? 1 : 0);
  if(this.is_active)
    {
      if(this.activity_level < this.no_activity_reset_timer_thresh)
        {
          //first kick of new game
          this.score_stats = new OnlineAverage();
          this.timer_value = 0;
          this.ball_position.clear(); //is this too late for this?
          this.IC._rollkick.init_position();
          this.speedometer.set_level(0, false, 0, true);
          this.speech_log.display_and_speak("Started game. Try to do " + parseInt(this.speedometer.target_goal) + " rolls per minute.");
        }
      else
        {
          //first kick after a period of rest in continuing game
          this.speech_log.display_and_speak("Good Job");
        }
    }
  else //became inactive
  {
    if(!this.will_reset)
      {
        //ball has not been kicked in a while but the game will continue if it is;
        this.speech_log.display_and_speak("Keep Going, Don't Give Up Now!");
      }
    else //can continue
      {
        //ball has not been kicked in so long that the game is now over
        var did_pass = (60 / this.score_stats.mean) >= this.speedometer.target_goal;
        var pass_message = (did_pass) ? "YES" : "NO";

        this.speech_log.display_and_speak("Game Over, You did " + (60.0 / this.score_stats.mean).toFixed(0) + " rolls per minute.");
        this.live_update_score_table(pass_message);
        this.score_log.commit_first_row();
      }
  }
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.live_update_score_table = function(pass_value)
{
  var val = this.timer_value * (this.timer_interval / 1000);
  val = parseInt(val.toString());

  var secs = val % 60;
  var mins = (val-secs) / 60;
  var time = mins.toFixed(0) + ":" + ("0" + secs).slice(-2);
  var n = this.score_stats.n;
  var rolls_per_minute = (60.0 / this.score_stats.mean).toFixed(2);
  this.score_log.live_update_first_row([n, rolls_per_minute, time , pass_value]);
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.timer_run = function()
{
  this.timer_run_loop();
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.timer_stop = function()
{
  clearTimeout(this.timer_thread);
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.timer_run_loop = function()
{
  var has_activity = this.activity_level > this.no_activity_stop_timer_thresh;
  if((!has_activity) && (this.is_active))
    {
      this.is_active = false;
      this.active_state_did_change(false, false);
    }

  var should_reset = this.activity_level < this.no_activity_reset_timer_thresh;
  
  if((should_reset) && (!this.will_reset))
    {
      this.will_reset = true;
      this.active_state_did_change(false, true);
    }

  if(has_activity)
    {
      ++this.timer_value;
      this.live_update_score_table("&mdash;");
    }

  this.activity_level *= this.activity_level_decay;

  //todo: how accurate is this? can I get system uptime in microseconds?
  this.timer_thread = setTimeout(this.timer_run_loop.bind(this), this.timer_interval);
}


/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.onrollkick = function(e)
{
  //ball did not roll to a stop
  if(e.duration_since_prev != 0)
    {
      if(!this.is_active)
        {
          this.is_active  = true;
          this.will_reset = false;
          this.active_state_did_change(true, false);
        }
      this.score_stats.update(e.duration_since_prev);
      var n = this.score_stats.n;
      var rolls_per_minute = (60.0 / this.score_stats.mean).toFixed(2);

      this.speedometer.set_level(rolls_per_minute, false, n, true);
      this.activity_level = 1.0;
    }
}

/*--------------------------------------------------------------------*/
Rollkick_Page_Template.prototype.onrolling = function(e)
{
  this.ball_position.update(e.x, e.y, 0);
}
