/*--__-_-_------_---_---_---_----_---------------------------_----------        _      _
   / _| (_)__ _| |_| |_| |_(_)__| |__  _ __  __ _ __ _ ___  | |_ ___ _ __  _ __| |__ _| |_ ___ 
  |  _| | / _` | ' \  _| / / / _| / / | '_ \/ _` / _` / -_) |  _/ -_) '  \| '_ \ / _` |  _/ -_)
  |_| |_|_\__, |_||_\__|_\_\_\__|_\_\ | .__/\__,_\__, \___|  \__\___|_|_|_| .__/_\__,_|\__\___|
----------|___/-----------------------|_|--------|___/------------------  |_|
  #HTML should look like this:

  <!--span id="transport"></span-->
  <span id="ball_status"></li>
  <button type="button" id="reset_button" onclick="template.clear()">RESET</button>
  <button type="button" id="video_modal">VIDEO</button>
  <canvas id="speedometer" width="400" height="400"></canvas>
  <canvas id="ball_position" width="600" height="300" style="width:100%;"></canvas>
  <table id="score_log"></table>
  <div id="speech_log"></div>
  <script>var template = new Rollkick_Page_Template($IC, ball_status, video_modal, VIDEO_PATH, speedometer, ball_position, score_log, speech_log, WDGETS_DIR, PAGE_NAME)</script>
----------------------------------------------------------------------*/


/*--------------------------------------------------------------------*/
function Flightkick_Page_Template(IC, user_id, height_dial_id, distance_dial_id, spin_dial_id, video_modal_id, ball_position_id, score_log_id, speech_log_id, widgets_directory)
{
  this.height_dial          = new Speedometer_Widget  (height_dial_id  , "meters"       , "height"  , widgets_directory);
  this.distance_dial        = new Speedometer_Widget  (distance_dial_id, "meters"       , "distance", widgets_directory);
  this.spin_dial            = new Speedometer_Widget  (spin_dial_id    , "radians / sec", "spin"    , widgets_directory);
  
  this.height_dial.set_level_and_num_ranges  (0, 16);
  this.distance_dial.set_level_and_num_ranges(0, 16);
  this.spin_dial.set_level_and_num_ranges    (0, 8 );
  this.height_dial.set_goal   (1);
  this.distance_dial.set_goal (3);
  this.spin_dial.set_goal     (2);
  this.height_dial.set_level  (0, true, 0, true);
  this.distance_dial.set_level(0, true, 0, true);
  this.spin_dial.set_level    (0, true, 0, true);  
  
  this.spin_dial.level_digits     = 
  this.spin_dial.num_digits       = 
  this.distance_dial.level_digits = 
  this.distance_dial.num_digits   = 
  this.height_dial.level_digits   = 
  this.height_dial.num_digits     = 1;
  
  this.video_modal          = new Video_Modal_Widget  (video_modal_id, ""); //set the video src when the page loads
  this.ball_position        = new Ball_Position_Widget(ball_position_id, widgets_directory);
  this.score_log            = new Score_Log_Widget    (score_log_id, user_id, "", ["DIST", "HIGHT", "SPEED", "SPIN", "DURATION", "FORCE", "SUCCESS"], [0,0,0,0,0,0,"&mdash;"]);
  this.speech_log           = new Speech_Log_Widget   (speech_log_id);
  this.IC                   = IC;
  
  this.speech_log.message_div.style.border = "none";
  this.speech_log.message_div.style.textAlign = "center";
  this.speech_log.message_div.style.backgroundColor = "white";
}

/*--------------------------------------------------------------------*/
Flightkick_Page_Template.prototype.page_load = function(name, video_path)
{
  this.video_modal.set_video(video_path);
  
  this.score_log.set_game_name(name);
  this.IC.onflight = this.onflight.bind(this);

  this.clear();
  this.IC.start_tracking();
}

/*--------------------------------------------------------------------*/
Flightkick_Page_Template.prototype.page_unload = function()
{
  this.IC.stop_tracking();
  this.IC.onflight = null;
}

/*--------------------------------------------------------------------*/
Flightkick_Page_Template.prototype.clear = function()
{
  //this.score_log.live_update_first_row(this.score_log.blank_row);
  
  this.height_dial.clear();
  this.distance_dial.clear();
  this.spin_dial.clear();
  
  this.speech_log.message_div.style.backgroundColor = "white";
  
  this.score_log.commit_first_row();
  this.ball_position.clear();
  this.IC.soft_init();
}
  


/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
Flightkick_Page_Template.prototype.onflight = function(e)
{
  switch(e.flight_state)
  {
    case Flightkick.STATE_AT_REST:
      this.speech_log.message_div.style.backgroundColor = "green";
      break;
    case Flightkick.STATE_POSSIBLY_FLYING:
      this.speech_log.message_div.style.backgroundColor = "yellow";
      break;
    case Flightkick.STATE_IN_FREEFALL:
      this.ball_position.update(e.x, e.y, e.z);
      this.speech_log.message_div.style.backgroundColor = "red";
      this.score_log.live_update_first_row([e.horizontal_distance.toFixed(2), e.height.toFixed(2), e.linear_speed.toFixed(2), e.spin.toFixed(2), e.flight_time.toFixed(2), e.force.toFixed(2), "&mdash;"]);
      break;
    case Flightkick.STATE_BOUNCING:
      this.speech_log.message_div.style.backgroundColor = "#8888FF";
    
  }
  if(e.ball_did_land)
    {
      var success = ((e.height >= this.height_dial.target_goal) && (e.horizontal_distance >= this.distance_dial.target_goal) && (e.spin >= this.spin_dial.target_goal)) ? "YES" : "NO";
      this.score_log.live_update_first_row([e.horizontal_distance.toFixed(2), e.height.toFixed(2), e.linear_speed.toFixed(2), e.spin.toFixed(2), e.flight_time.toFixed(2), e.force.toFixed(2), success]);
      
      this.height_dial.set_level(e.height, false, e.height, false);
      this.distance_dial.set_level(e.horizontal_distance, false, e.horizontal_distance, false);
      this.spin_dial.set_level(e.spin, false, e.spin, false);
    }
  //probably overkill to do this every 10 ms;
  this.speech_log.display(e.flight_state_message);
}

