/*--_------_-------------------_---------_---------_-_---------_--------
 __| |__ _| |_ __ _   _ _ __ _| |_ ___  (_)_ _  __| (_)__ __ _| |_ ___ _ _ 
/ _` / _` |  _/ _` | | '_/ _` |  _/ -_) | | ' \/ _` | / _/ _` |  _/ _ \ '_|
\__,_\__,_|\__\__,_| |_| \__,_|\__\___| |_|_||_\__,_|_\__\__,_|\__\___/_|  
------------------------------------------------------------------------
    
  #HTML should look like this:
  
  <canvas width="300" height="300" id="speedometer_canvas">
  </canvas>
----------------------------------------------------------------------*/

//PUBLIC
/*--------------------------------------------------------------------*/
function Data_Rate_Widget(canvas_id)
{
  this.canvas       = document.getElementById(canvas_id);
  this.context      = this.canvas.getContext('2d');
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Data_Rate_Widget.prototype.init = function()
{
  this.level_min     = 0; 
  this.level_max     = 100;
  this.target_level  = 0;
  this.current_level = this.target_level;
  this.interpolation_thread_runloop_duration = 75; //ms
  this.half_canvas_width  = 0.5 * this.canvas.width;
  this.half_canvas_height = 0.5 * this.canvas.height;
  this.radius = Math.min(this.half_canvas_width, this.half_canvas_height);
  
  this.interpolation_thread_run_loop_run();
}

//PUBLIC
/*--------------------------------------------------------------------*/
// the dial value is set independently of the center number.
// either can be set immediately, or interpolated
Data_Rate_Widget.prototype.set_level = function(sample_interval, expected_interval, max_interval)
{
  //interpolation_thread_run_loop_lock()
  this.target_level = this.scalef(sample_interval, expected_interval, max_interval, 0.0, 1.0);
  this.target_level = this.clip(this.target_level, 0.0, 1.0);

  //jump up but interpolate down
  if(this.target_level > this.current_level)
    this.current_level = this.target_level;
    
  //interpolation_thread_run_loop_unlock()
}

//PRIVATE
/*--------------------------------------------------------------------*/
Data_Rate_Widget.prototype.set_level_private = function(level, num)
{
  var hue = 100 - (this.current_level * 100);
  var r = this.radius * 0.9;
  
  this.context.clearRect(0, 0, this.canvas.width, this.canvas.height); 
  this.context.beginPath();
  this.context.strokeStyle = "rgb(0, 0, 0)";
  this.context.lineWidth = 0.16 * this.radius;
  this.context.fillStyle = "rgb(100%, " + hue + "%, " + hue + "%)";
  this.context.ellipse(this.half_canvas_width, this.half_canvas_height, r, r, 0, 0, (2*Math.PI), false);
  this.context.stroke();
  this.context.fill();
}

//PRIVATE
/*--------------------------------------------------------------------*/
Data_Rate_Widget.prototype.scalef = function(x, in_min, in_max, out_min, out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Data_Rate_Widget.prototype.clip = function(x, min, max)
{
  return (x < min) ? min : (x > max) ? max : x;
}
//PRIVATE
/*--------------------------------------------------------------------*/
Data_Rate_Widget.prototype.interpolation_thread_run_loop_run = function()
{
  this.current_level = (0.9 * this.current_level) + (0.1 * this.target_level);
  this.set_level_private(this.current_level, this.current_num);
  setTimeout(this.interpolation_thread_run_loop_run.bind(this), this.interpolation_thread_runloop_duration);
}



