/*---------------------_---------------_--------------------_----_------    _
   ____ __  ___ ___ __| |___ _ __  ___| |_ ___ _ _  __ __ _(_)__| |__ _ ___| |_ 
  (_-< '_ \/ -_) -_) _` / _ \ '  \/ -_)  _/ -_) '_| \ V  V / / _` / _` / -_)  _|
  /__/ .__/\___\___\__,_\___/_|_|_\___|\__\___|_|    \_/\_/|_\__,_\__, \___|\__|
-----|_|----------------------------------------------------------|___/-  
    
  #HTML should look like this:
  
  <canvas width="300" height="300" id="speedometer_canvas">
  </canvas>
----------------------------------------------------------------------*/

//PUBLIC
/*--------------------------------------------------------------------*/
function Circle_Indicator_Widget(canvas_id)
{
  this.canvas       = document.getElementById(canvas_id);
  this.context      = this.canvas.getContext('2d');
  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Circle_Indicator_Widget.prototype.init = function()
{
  this.level_min     = 0; 
  this.level_max     = 100;
  this.num_min       = 0; 
  this.num_max       = 100;
  this.num_segments  = 100;
  this.target_level  = 0;
  this.current_level = this.target_level;
  this.target_num    = 0;
  this.current_num   = this.target_num;
  this.interpolation_thread_runloop_duration = 75; //ms
  
  this.interpolation_thread_run_loop_run();
}

//PUBLIC
/*--------------------------------------------------------------------*/
// the dial value is set independently of the center number.
// either can be set immediately, or interpolated
Circle_Indicator_Widget.prototype.set_level = function(level, level_immediate, num, num_immediate)
{
  //interpolation_thread_run_loop_lock()
  this.target_level = this.clip(level, this.level_min, this.level_max);
  this.target_num   = this.clip(num  , this.num_min  , this.num_max  );
  
  if(level_immediate)
    this.current_level = level;
  if(num_immediate)
    this.current_num = num;    
  //interpolation_thread_run_loop_unlock()
}

//PRIVATE
/*--------------------------------------------------------------------*/
Circle_Indicator_Widget.prototype.set_level_private = function(level, num)
{
  var i;
  var radius = 0.5 * Math.min(this.canvas.width, this.canvas.height);
  this.context.lineWidth = radius * 0.2;
  radius -= this.context.lineWidth*0.5
  var start = 0.75 * Math.PI;
  var end   = 2.25 * Math.PI;
  var increment = (end - start) / this.num_segments;
  var start_hue = 0;
  var end_hue = 120;
  var hue_increment = (end_hue - start_hue) / this.num_segments;
  var brightest_segment = this.scalef(level, this.level_min, this.level_max, 0, this.num_segments-1);
  var spread_squared = 20;
  var saturation, ligheness;

  var number = 0;

  this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
  
  for(i=0; i<this.num_segments; i++)
    {
      var offset = i-brightest_segment;
      var temp = Math.pow(Math.E, -(offset*offset)/(2*spread_squared));
      lightness  = this.scalef(temp, 0, 1, 25, 80);
      saturation = this.scalef(temp, 0, 1, 75, 100);
      this.context.beginPath();
      this.context.strokeStyle = "hsl("+start_hue+", "+saturation+"%, "+ lightness +"%)";
      this.context.arc(this.canvas.width*0.5, this.canvas.height*0.5, radius, start, start+increment, false);
      start += increment;
      start_hue += hue_increment;
      this.context.stroke();
    }
    
  this.context.textBaseline="middle";
  this.context.textAlign="center"; 
  this.context.font = "bold " + 0.92*radius + "px Arial";
  this.context.fillText(parseInt(num).toFixed(0), this.canvas.width*0.5, this.canvas.height*0.5);
}

//PRIVATE
/*--------------------------------------------------------------------*/
Circle_Indicator_Widget.prototype.scalef = function(x, in_min, in_max, out_min, out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Circle_Indicator_Widget.prototype.clip = function(x, min, max)
{
  return (x < min) ? min : (x > max) ? max : x;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Circle_Indicator_Widget.prototype.create_image = function(src)
{
  var img = document.createElement("IMG");
  img.src = src;
  img.style.display = "none";
  document.body.appendChild(img);
  return img;
}

//PRIVATE
/*--------------------------------------------------------------------*/
Circle_Indicator_Widget.prototype.interpolation_thread_run_loop_run = function()
{
  this.current_level = (0.8 * this.current_level) + (0.2 * this.target_level);
  this.current_num   = (0.8 * this.current_num)   + (0.2 * this.target_num  );
  this.set_level_private(this.current_level, this.current_num);
  setTimeout(this.interpolation_thread_run_loop_run.bind(this), this.interpolation_thread_runloop_duration);
}



