// JavaScript Document

function Chart(settings){
	this.settings = settings;
	this.canvas = document.getElementById(this.settings.canvasID);
	this.context = this.canvas.getContext('2d');
	//this.lastY = {};
		
	this.canvas.width = this.settings.width;
	this.canvas.height = this.settings.height;
  this.data = new Array();
  
	this.clear();
	
	
	var s = this.settings;
	
	if(s.hasOwnProperty('legendID')){
		var $l = $('#'+s.legendID);
		for(var field in s.fields){
			var sf = s.fields[field];
			$l.append($('<span style="color:'+ sf.color+';">&mdash;'+field+'&mdash;&emsp;</span>'));
		}
	}
  
  this.refresh_run_loop();
};

Chart.prototype.clear = function(x0, x1){
	var s = this.settings;
	var c = this.context;
	if('undefined' === typeof x0) x0 = 0;
	if('undefined' === typeof x1) x1= s.width-1;	
	//draw background
	c.fillStyle = s.background_color;
	c.fillRect(x0,0,x1-x0+1,s.height);
	//draw grid
	var y = s.grid_h_origin;
	this.line(x0,y,x1+1,y,s.grid_h_origin_color,1);
}

Chart.prototype.line = function(x0,y0, x1,y1, strokeStyle,lineWidth){
	var s = this.settings;
	var c = this.context;
	if('undefined' !== typeof strokeStyle) c.strokeStyle = strokeStyle;
	if('undefined' !== typeof lineWidth) c.lineWidth = lineWidth;	
	c.beginPath();
	c.moveTo(x0,y0);
	c.lineTo(x1,y1);
	c.stroke();	
}

Chart.prototype.update = function(data)
{
  this.data.unshift(data);
  while(this.data.length > this.canvas.width-1)
    this.data.pop();
}

Chart.prototype.refresh_run_loop = function()
{
  if(this.data.length > 1)
    {
	var s = this.settings;
	var c = this.context;
	var W = c.canvas.width;
	var H = c.canvas.height;
	var i;

  this.clear();
  
  for(var field in s.fields)
    {
      var sf = s.fields[field];
      var ppu = H / (sf.max - sf.min);    //pixels per unit
      
      c.strokeStyle = sf.color;
      c.beginPath();
      
      c.moveTo(W-1, H - (this.data[0][field] - sf.min) * ppu)
      
      for(i=1; i<this.data.length; i++)
        c.lineTo(W-1-i, H - (this.data[i][field] - sf.min) * ppu);
      
      c.stroke();
    }
    }
  setTimeout(this.refresh_run_loop.bind(this), 33);
}

