/*-_----------_-_------_--------_--------------------_----_----------_--
  | |__  __ _| | |  __| |_ __ _| |_ _  _ ___ __ __ _(_)__| |__ _ ___| |_ 
  | '_ \/ _` | | | (_-<  _/ _` |  _| || (_-< \ V  V / / _` / _` / -_)  _|
  |_.__/\__,_|_|_| /__/\__\__,_|\__|\_,_/__/  \_/\_/|_\__,_\__, \___|\__|
-----------------------------------------------------------|___/--------
  <span id="ball_status"></li>
  <script>var template = new Ball_Status_Widget($IC, 'ball_status', widgets_dir)</script>
----------------------------------------------------------------------*/


//PUBLIC
/*--------------------------------------------------------------------*/
function Ball_Status_Widget(IC, container_id, path_to_widgets)
{
  
  this.container  = document.getElementById(container_id);
  this.volts      = new Level_Indicator(path_to_widgets + "ball_status/batt/" , 0, 4, ".png", 3.0, 4.2, 0);
  this.rssi       = new Level_Indicator(path_to_widgets + "ball_status/wifi/" , 0, 4, ".png", -90, -30, -90);
  this.calibrated = new Level_Indicator(path_to_widgets + "ball_status/calib/", 0, 1, ".png",   0,   1, 0);
  
  this.IC         = IC;
  this.init_ic_callbacks();
  
  this.container.appendChild(this.volts.img);
  this.container.appendChild(this.rssi.img);
  this.container.appendChild(this.calibrated.img);
}

/*--------------------------------------------------------------------*/
Ball_Status_Widget.prototype.init = function()
{
  this.volts.set_level(0);
  this.rssi.set_level(-90);
  this.calibrated.set_level(0);
}

//PUBLIC
/*--------------------------------------------------------------------*/
Ball_Status_Widget.prototype.update = function(volts, rssi, calibrated)
{
  this.volts.set_level(volts);
  this.rssi.set_level(rssi);
  var calibrated_level = (calibrated == "11111111") ? 1 : 0;
  this.calibrated.set_level(calibrated_level);
}

/*--------------------------------------------------------------------*/
Ball_Status_Widget.prototype.init_ic_callbacks  = function()
{
  this.IC.onstatus         = this.onstatus.bind(this);
  this.IC.onconnection     = this.onconnection.bind(this);
}

/*--------------------------------------------------------------------*/
Ball_Status_Widget.prototype.onstatus = function(e)
{
  this.update(e.volts, e.rssi, e.calibrated);
}

/*--------------------------------------------------------------------*/
Ball_Status_Widget.prototype.onconnection = function(e)
{
  if(e.status != this.IC.STATUS_CONNECTED)
    {
      this.update(0, -90, 0);
      //this.keep_trying_to_connect();
      //speech_log.display_and_speak("Ball Disconnected from wifi");
    }
}

/*--------------------------------------------------------------------*/
Ball_Status_Widget.prototype.keep_trying_to_connect = function()
{
  var connected = this.IC.is_connected();
  if(connected === null) connected = false;

  if(!connected)
    {
      this.IC.stop_tracking();
      this.IC.start_tracking();
      //this is might cause a number of problems... (e.g. with playback of saved data)
      setTimeout(this.keep_trying_to_connect.bind(this), 2000);
    }
}

/*--------------------------------------------------------------------*/
/*-_-------------_---_---------_-_---------_----------------------------
  | |_____ _____| | (_)_ _  __| (_)__ __ _| |_ ___ _ _ 
  | / -_) V / -_) | | | ' \/ _` | / _/ _` |  _/ _ \ '_|
  |_\___|\_/\___|_| |_|_||_\__,_|_\__\__,_|\__\___/_| 
----------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
function Level_Indicator(folder, start_image_number, end_image_number, extension, start_range, end_range, initial_level)
{
  var i;
  this.image_names = new Array();
  this.current_image_name = "";
  for(i=start_image_number; i<=end_image_number; i++)
    {
      var name = folder+i+extension;
      this.image_names.push(name);
    }
  this.start_range = start_range;
  this.end_range = end_range;
  
  this.img = document.createElement("img");
  this.img.style.width  = "46px";
  this.img.style.hieght = "46px";
  this.img.style.display = "inline-block";
  
  this.set_level(initial_level);
}

/*--------------------------------------------------------------------*/
Level_Indicator.prototype.set_level = function(level)
{
  var index = this.scalef(level, this.start_range, this.end_range, 0, this.image_names.length);
  index = this.clip(index, 0, this.image_names.length-1);
  index = parseInt(index);

  this.img.src = this.image_names[index];
}

/*--------------------------------------------------------------------*/
Level_Indicator.prototype.scalef = function(x, in_min, in_max, out_min, out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

/*--------------------------------------------------------------------*/
Level_Indicator.prototype.clip = function(x, in_min, in_max)
{
  if(x < in_min)
    x = in_min;
  if(x > in_max)
    x = in_max;
  return x;
}

