/*-_----------_-_----------------_-_---_-------------------_----_-------   _
  | |__  __ _| | |  _ __  ___ __(_) |_(_)___ _ _   __ __ _(_)__| |__ _ ___| |_ 
  | '_ \/ _` | | | | '_ \/ _ (_-< |  _| / _ \ ' \  \ V  V / / _` / _` / -_)  _|
  |_.__/\__,_|_|_| | .__/\___/__/_|\__|_\___/_||_|  \_/\_/|_\__,_\__, \___|\__|
-------------------|_|-------------------------------------------|___/-- 
  #include <THREE.js>
  
  #HTML should look like this:
  <canvas width="300" height="300" id="ball_position_canvas"></canvas>
  <script>var Ball_Position_Widget_3D = new Ball_Position_Widget_3D('ball_position_canvas')</script>
----------------------------------------------------------------------*/

//PUBLIC
/*--------------------------------------------------------------------*/
function Ball_Position_Widget_3D(div_id, path_to_widgets)
{
  this.div = document.getElementById(div_id);
  this.scene  = new THREE.Scene();
 var light = new THREE.AmbientLight(0xFFFFFF);
 this.scene.add(light);
   this.camera = new THREE.PerspectiveCamera( 75, this.div.offsetWidth / this.div.offsetHeight, 0.1, 1000 );
  this.renderer = new THREE.WebGLRenderer();
  this.renderer.setSize( this.div.offsetWidth, this.div.offsetHeight );
  document.body.appendChild( this.renderer.domElement );

  this.init();
}

//PUBLIC
/*--------------------------------------------------------------------*/
Ball_Position_Widget_3D.prototype.init = function()
{

  var geometry = new THREE.SphereGeometry(0.22, 15, 15);
  //var material = new THREE.MeshBasicMaterial({ color: 0x00ff00 });
  
  var texture = new THREE.TextureLoader().load( "ball_1.png" );
  texture.wrapS = THREE.RepeatWrapping;
  texture.wrapT = THREE.RepeatWrapping;
  texture.repeat.set(1, 1);
  
  var material = new THREE.MeshLambertMaterial({map: texture});
  
  this.cube = new THREE.Mesh(geometry, material);
  this.scene.add(this.cube);

  this.camera.position.z = 2;


  //this.clear();
  this.render_run_loop_run();
}

//PRIVATE
/*--------------------------------------------------------------------*/
Ball_Position_Widget_3D.prototype.render_run_loop_run = function() 
{
	requestAnimationFrame( this.render_run_loop_run.bind(this) );
  
  this.cube.rotation.x += 0.01;
  this.cube.rotation.y += 0.01;
        
	this.renderer.render( this.scene, this.camera );
}

//PUBLIC
/*--------------------------------------------------------------------*/
Ball_Position_Widget_3D.prototype.clear = function()
{

}

//PUBLIC
/*--------------------------------------------------------------------*/
Ball_Position_Widget_3D.prototype.animate = function(x, y, z)
{

}

//PRIVATE
/*--------------------------------------------------------------------*/
Ball_Position_Widget_3D.prototype.create_image = function(src)
{
  var img = document.createElement("IMG");
  img.src = src;
  img.style.display = "none";
  document.body.appendChild(img);
  return img;
}

