<?php
include('../_template.php');

$description = 'Music will play whie the ball is moving';

$file_version="1.3";
top_of_page_crap($description, $file_version, $report);
include_speedometer_widget();
?>

<div style="margin:auto; text-align:center;">
  <div class="slider_widget">
    <audio id="audio_player" controls volume="0">
      <source src="sound/music.mp3" type="audio/mpeg">
    </audio><br>
    <input id="vol_display_slider" type="range" min="0" max="1" step="0.01" value="0"></input>
  </div>
  <audio id="encouragement_audio" style="display:none;" controls volume="1">
    <source src="" type="audio/mpeg">
  </audio><br>
  <canvas width="300" height="300" id="speedometer_canvas"></canvas>
</div>

<?php middle_of_page_crap(); ?>
/* todo: statistics should be done by API or app? */
force_average = new OnlineAverage();
spin_average  = new OnlineAverage();
dist_average  = new OnlineAverage();
dur_average   = new OnlineAverage();

var speedometer = new Speedometer_Widget("speedometer_canvas", "kicks / min", "KICKS",  "../widgets/", Speedometer_Widget.STYLE_SPEEDOMETER, Speedometer_Widget.GOAL_TYPE_AT_LEAST);
speedometer.resume_updating();


$IC.onrollkick = function rollkick_event_handler(e)
{
  //e.distance_since_previous==0 indicates ball kicked from stationary, reports force and spin only
  if(e.distance_since_previous != 0)
    {
      dist_average.update  (e.distance_since_prev);
      dur_average.update   (e.duration_since_prev);
    }
    
  //force==0 indicates ball stopped rolling, reports duration and distance only
  if(e.force != 0)
    {
      var k_min = 0;
      if(dur_average.mean > 0)
        k_min = 60.0 / dur_average.mean;
        
      force_average.update (e.force);
      spin_average.update  (e.spin);
      raise_volume();
      needs_encouragement = true;
      speedometer.set_level(k_min, false, force_average.n, true);
    }
/*
  msg("force_current", e.force);
  msg("force_avg"    , force_average.mean);
  msg("force_var"    , force_average.variance);
  msg("spin_current" , e.spin);
  msg("spin_avg"     , spin_average.mean);
  msg("spin_var"     , spin_average.variance);
  msg("dist_current" , e.distance_since_prev);
  msg("dist_avg"     , dist_average.mean);
  msg("dist_var"     , dist_average.variance);
  msg("dur_current"  , e.duration_since_prev);
  msg("dur_avg"      , dur_average.mean);
  msg("dur_var"      , dur_average.variance);
*/
}

function reset_stats()
{
  force_average = new OnlineAverage();
  spin_average  = new OnlineAverage();
  dist_average  = new OnlineAverage();
  dur_average   = new OnlineAverage();
  //lazyness. todo: get rid of repeated code
  msg("force_current", 0);
  msg("force_avg"    , 0);
  msg("force_var"    , 0);
  msg("spin_current" , 0);
  msg("spin_avg"     , 0);
  msg("spin_var"     , 0);
  msg("dist_current" , 0);
  msg("dist_avg"     , 0);
  msg("dist_var"     , 0);
  msg("dur_current"  , 0);
  msg("dur_avg"      , 0);
  msg("dur_var"      , 0);
  ball_position_widget.clear();
  chart1.clear();
  speedometer.clear();
  $IC.soft_init();
}

function subclass_start()
{
  volume_thread_run_loop_run();
  play_audio_file("sound/music.mp3", "audio_player");
}

function subclass_stop()
{
  volume_thread_run_loop_cancel();
  stop_audio_file("audio_player");
}
        
/* AUDIO CRAP BEOW HERE */
var filtered_volume = 0;
var actual_volume   = 0;
var target_volume   = 0;
var volume_thread;
var volume_thread_interval = 100; //millisecs
var encouraging_message_retrigger_interval  = 20000; //millisecs
var encouraging_message_retrigger_timer = 0; //millisecs
var needs_encouragement = false;
    
function change_volume(vol)
{
  if(vol > 1) vol = 1;
  if(vol < 0) vol = 0;
  
  document.getElementById("vol_display_slider").value = vol;
  
  //vol [0 ~ 1] to decibels [-70dB - 0dB]
  vol = vol-1;
  vol *= 70;
  
  //decibels to gain [0 ~ 1];
  //(so that equal steps sizes are perceptually the same cahnge in loudness)
  if(vol <= -70)
    vol = 0;
  else
    {
      vol *= 0.1;
      vol = Math.pow(2, vol);
    }
  document.getElementById("audio_player").volume = vol;
}
  
function raise_volume()
{
  //gain only goes to 1,
  //but filter overshoots so
  //it stays at 1 for a bit
  filtered_volume = 1.75;
}

function play_encouragement()
{
  var encouragements = 
    [
      "sound/Almost_There_Alex.mp3",
      "sound/Almost_There_Samantha.mp3",
      "sound/Dont_Give_Up_Now_Alex.mp3",
      "sound/Dont_Give_Up_Now_Samantha.mp3",
      //"sound/Good_Job_Alex.mp3",
      //"sound/Good_Job_Samantha.mp3",
      "sound/Keep_Going_Alex.mp3",
      "sound/Keep_Going_Samantha.mp3"
    ];
  var r = parseInt(Math.random() * encouragements.length);
  if(r > encouragements.length) r=encouragements.length; //can random() return 1?
  
  play_audio_file(encouragements[r], "encouragement_audio");
  encouraging_message_retrigger_timer = 0;
  needs_encouragement = false;
}

function stop_audio_file(element_id)
{
  var audio_element = document.getElementById(element_id);
  audio_element.pause();
}

function play_audio_file(filename, element_id)
{
  var audio_element = document.getElementById(element_id);
  var extension = '.stereo.mp3';
  var type = 'audio/mpeg';
  
  audio_element.src  = filename;
    
  if(audio_element.addEventListener)
    audio_element.addEventListener("canplay", audio_file_loaded, false);
  else if(audio_element.attachEvent)
    audio_element.attachEvent("oncanplay", audio_file_loaded);
  else
    audio_element["oncanplay"] = audio_file_loaded;
}
  
function audio_file_loaded(e)
{
  var audio_element = e.target;
  /*
   * remove the event, because on some browsers (Firefox) jumping to a new location
   * will trigger this event again, recursively ad inf.
   */
  if(audio_element.removeEventListener)
    audio_element.removeEventListener("canplay", audio_file_loaded);
  else if(audio_element.detachEvent)
    audio_element.detachEvent("oncanplay", audio_file_loaded);
  else
    audio_element["oncanplay"] = null;
    
  audio_element.play();
}

function volume_thread_run_loop_run()
{
  filtered_volume = actual_volume = (filtered_volume * 0.95) + (target_volume * 0.05);
  if(actual_volume < 0.01) actual_volume = 0.0;
  change_volume(actual_volume);
  
  //if((filtered_volume < 0.01) && (encouraging_message_retrigger_timer > encouraging_message_retrigger_interval) && (needs_encouragement))
    //play_encouragement();
  
  encouraging_message_retrigger_timer += volume_thread_interval;
  
  volume_thread = setTimeout(volume_thread_run_loop_run, 100);
}

function volume_thread_run_loop_cancel()
{
  clearTimeout(volume_thread);
}

add_button("clear", reset_stats);

<?php end_of_page_crap(); ?>
