<?php
include('../_template.php');

$description = 'This is a roll-kick style game that plays a sound every time the ball is kicked. There are no visual elements, just sound. On IOS you might have to press the "Play Sound" button once to unlock webAudio before this works';

$file_version="1.0";
$report = "";
top_of_page_crap($description, $file_version, $report);
include_speedometer_widget();
?>
<script src="Audio_File_Player.js"></script>

<!-- this audio player is not currently used, it is just here incase webAudio does not exist on this machine -->
    <?php
      $files = glob("sound/MJ/*.mp3");
      foreach ($files as $file)
        {
          $basename = basename($file);
          echo "<audio id='$basename' style='display:none;' controls volume='1'>";
          echo "<source src='' type='audio/mpeg'>";
          echo "</audio>";
        }
    ?>

<canvas width="300" height="300" id="speedometer_canvas" style="display:block; margin:auto"></canvas>
  
<?php middle_of_page_crap(); ?>

var speedometer = new Speedometer_Widget("speedometer_canvas", "Newtons", "FORCE",  "../widgets/", Speedometer_Widget.STYLE_SPEEDOMETER, Speedometer_Widget.GOAL_TYPE_RANGE);
speedometer.resume_updating();

$IC.onrollkick = function rollkick_event_handler(e)
{
  //force==0 indicates ball stopped rolling, reports duration and distance only
  //so here, ball was kicked, e.g. it did not roll to a stop  
  if(e.force !== 0)
    {
      play_encouragement();
      speedometer.set_level(e.force, false, e.force, true);
    }
}



var encouragements = 
  [
    <?php 
      $files = glob("sound/MJ/*.mp3");
      foreach ($files as $file)
        {
          $basename = basename($file);
          echo "new Audio_File_Player('" . $file . "', '$basename'),\r\n\t";
        }
    ?>
  ];

function play_encouragement()
{
  var r = parseInt(Math.random() * encouragements.length);
  if(r > encouragements.length) r=encouragements.length; //can random() return 1?
  encouragements[r].play();
}

/*
function play_sound(value, lowest, highest)
{
  value = scalef(value, lowest, highest, 0, 1);
  var a = loud;
  
  if(value < 1.0/3.0)
    a = soft
  else if (value < 2.0/3.0)
    a = meduim;
    
  var r = parseInt(Math.random() * a.length);
  if(r > a.length) r=a.length; //can random() return 1?
  a[r].play();
}
*/

add_button("play sound", play_encouragement);

<?php end_of_page_crap(); ?>
