<?php

function make_slider_widget($title, $min, $max, $start, $step, $oninput)
{
?>
  <div class="slider_widget">
    <?php echo($title); ?><br>
    <input oninput="msg('<?php echo($title);?>', this.value); <?php echo($oninput)?>" type="range" min="<?php echo($min); ?>" max="<?php echo($max); ?>" step="<?php echo($step); ?>" value="<?php echo($start); ?>"><br>
    <span style="float:left"><?php echo($min); ?></span><span id="<?php echo($title); ?>"><?php echo($start); ?></span><span style="float:right"><?php echo($max); ?></span>
  </div>
<?php 
}

function make_toggle_widget($title, $js_parameter, $checked)
{
?>
  <div class="slider_widget">
    <?php echo($title); ?><br>
    <input type="checkbox" onclick="<?php echo($js_parameter)?> = !<?php echo($js_parameter)?>" <?php if($checked) echo("checked");?>><br>
    <span>&nbsp;</span>
  </div>
<?php 
}

function include_chart_widget()
{
?>
  <script src="../lib/threejs/three.min.js"></script> 
  <script src="../lib/zepto/zepto.min.js"></script>
  <script src="../widgets/chart.js"></script>
<?php 
}

function include_ball_position_widget()
{?>
  <script src="../widgets/ball_position/widget.js"></script>
  <script src="../widgets/ball_position_3d/widget.js"></script>
<?php 
}

function include_speedometer_widget()
{?>
  <script src="../widgets/speedometer/widget.js"></script>
<?php 
}


function top_of_page_crap($description, $file_version, $report)
{
  $script_name = basename($_SERVER["SCRIPT_FILENAME"], ".php");
  $page_title = str_replace("_", " ", $script_name);
?>

<!doctype html>
<html lang="en">
  <head> 
    <meta charset="UTF-8">
    <title>Inside Coach | <?php echo($page_title); ?></title>
    <meta name="author" content="Michael Krzyzaniak at Inside Coach">
    <meta name="description" content="Demo for <?php echo($page_title);?>">
    <meta name="keywords" content="Inside Coach">
    <link rel="icon" href="../../favicon.ico" />

    <?php if(isset($_GET['debug'])){ ?>
    <script type="text/javascript" src="../../api/src/DeltaCalculator.js"></script>
    <script type="text/javascript" src="../../api/src/IC.js"></script>
    <script type="text/javascript" src="../../api/src/Algebra.js"></script>
    <script type="text/javascript" src="../../api/src/Memory_Map.js"></script>
    <script type="text/javascript" src="../../api/src/FIR_Filter.js"></script>
    <script type="text/javascript" src="../../api/src/Calibration.js"></script>
    <script type="text/javascript" src="../../api/src/Orientation.js"></script>
    <script type="text/javascript" src="../../api/src/Flightkick.js"></script>
    <script type="text/javascript" src="../../api/src/Flightkick_2.js"></script>
    <script type="text/javascript" src="../../api/src/Rollkick.js"></script>
    <script type="text/javascript" src="../../api/src/Statistics.js"></script>
    <script type="text/javascript" src="../../api/src/Centripetal.js"></script>
    <script type="text/javascript" src="../../api/src/IC_LEVEL_2.js"></script>
    <?php }else{ ?>    
    <script type="text/javascript" src="../../api/Inside-Coach-API.js"></script>
    <?php } ?> 
    <script type="text/javascript" src="../lib/pako-master/dist/pako.min.js"></script>
    <link rel="stylesheet" media="all" type="text/css" href="../styles.css" />
  <head>

  <body>
    <div class="page_div">
      <a href="../../index.php" style="display:block; float:right; font-size:1.25em;">[MENU]</a>
      <?php if($report != ""){ ?>
      <a href="<?php echo '../../reports/' . $report . '.pdf' ?>" style="display:block; float:right; margin-right:2em; font-size:1.25em;">[WHITEPAPER]</a>
      <?php } ?>
      <h1><img style="height:1em;vertical-align:bottom;" src="../icons/logo.png"> <a href="http://insidecoach.com" style="text-decoration:none;">Inside Coach</a> &#X2014; <?php echo($page_title);?></h1>
      <div class="description_div"><?php echo($description); ?></div>

      <hr>
      <div class="buttons" id="buttons" style="clear:both">
        <span class="transport_div">
          <div id="rewind_button" onmouseover='this.style.backgroundPosition="0% 100%";' onmouseout='this.style.backgroundPosition="0% 0%";' onclick="rewind()"></div>
          <div id="stop_button" onmouseover='this.style.backgroundPosition="0% 100%";' onmouseout='this.style.backgroundPosition="0% 0%";' onclick="stop()"></div>
          <div id="play_button" onmouseover='this.style.backgroundPosition="0% 100%";' onmouseout='this.style.backgroundPosition="0% 0%";' onclick="play()"></div>
          <div id="play_button_alt" onmouseover='this.style.backgroundPosition="0% 100%";' onmouseout='this.style.backgroundPosition="0% 0%";' onclick="play()"></div>
          <div id="record_button" onmouseover='this.style.backgroundPosition="0% 100%";' onmouseout='this.style.backgroundPosition="0% 0%";' onclick="toggle_record()"></div>
          <div id="record_button_alt" onmouseover='this.style.backgroundPosition="0% 100%";' onmouseout='this.style.backgroundPosition="0% 0%";' onclick="toggle_record()"></div>
          <table id="timer_table">
            <tr><td id="record_timer_minutes">00</td>
            <td>:</td>
            <td id="record_timer_seconds">00</td>
            </tr>
          </table>
        </span>

        <!--button id="save_data_button" onclick="show_save_data_modal()" style="vertical-align:center">Save Recording</button-->
        <div id="save_data_modal" class="modal">
          <div class="modal-content" style="max-width:300px">
            <span class="close" onclick="hide_save_data_modal();">&times;</span><br>
            <h2>Save Recorded Data</h2>
            <h3>(you must be connected to the internet)</h3>
            <form id="save_data_form" method="post" action="/demo/_save_user_data.php" enctype="multipart/form-data">
              description: (optional)<br>
              <textarea rows="4" cols="30" name="description" style="resize:vertical"></textarea><br>
              <input type="hidden" name="action" value="save"><br>
              <input type="hidden" name="saved_json_data" value=""><br>
              <input type="hidden" name="uses_bno_calibration" value=""><br>
              <input type="hidden" name="redirect" value='<?php echo("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]")?>'>
              <input type="hidden" name="table_name" value='<?php echo($script_name);?>'> 
              <input type="hidden" name="score" value="0">
              <input type="submit">
            </form>
          </div>
        </div>

        <button id="show_input_sources" onclick="show_input_sources_modal()" style="vertical-align:center">Input Source: Ball</button>
        <div id="input_sources_modal"  class="modal">
          <div class="modal-content" style="max-width:600px">
            <span class="close" onclick="hide_input_sources_modal();">&times;</span><br>
            <h2>Input Sources</h2>
            <h3>(you must be connected to the internet)</h3>
            <table style="width:100%; text-align:left; border:1px solid" id="input_sources_table">
              <tr>
                <th>description</th>
                <th>time</th>
                <!--th>score</th-->
                <th>delete</th>
                <th>view</th>
              </tr>
              <tr>
                <td><a href="#" onclick="open_ball_input_source()">[Live Input From The Ball]</a></td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <!--td>&nbsp;</td-->
              </tr>
            <?php
              date_default_timezone_set('UTC');
              $db = new SQLite3("../saved_data/database.db");
              $db->exec("create table if not exists '". $script_name ."'(filename TEXT, unix_epoch TEXT, uses_bno_calibration TEXT, description TEXT, score TEXT);");
              $rows = $db->query("select * from '" . $script_name . "';");
              while(($row = $rows->fetchArray(SQLITE3_ASSOC)) != FALSE)
                {
                  echo "<tr>";
                  echo "<td><a href='#' onclick='open_saved_json_input_source(" . $row['unix_epoch'] . ")'>[" . htmlspecialchars(trim(strip_tags($row['description']))) . "]</a></td>"; //sanitization was also performed when inserted into database (this is redundant)
                  echo "<td>" . date('l j F Y h:i:s A', $row['unix_epoch']) . " UTC</td>";
                  echo "<td><a class='delete_button' href='#' onclick='delete_saved_data(\"http://{$_SERVER[HTTP_HOST]}{$_SERVER[REQUEST_URI]}\", {$row['unix_epoch']}, \"$script_name\", \"{$row['description']}\")'>x</a></td>";
                  //echo "<td> {$row['score']} </td>";
                  echo "<td><a href='#' onclick='view_json_data(" . $row['unix_epoch'] . ")'>view</a></td>";
                  echo "</tr>";
                }
            ?>
            </table>
          </div>
        </div>
        
        <!-- fusion mode is selected automatically by API based on ball firmware -->
        <!-- select onchange="toggle_fusion_mode(this);">
          <option value="TRUE">BNO Fusion</option>
          <option value="FALSE">Inside Coach Fusion</option>
        </select -->
        <button onclick="$IC.reset_calibration();">Reset IC Calibration</button>
        <!--span style="border:1px solid #BBB; display:inline-block">
          <input type="checkbox" onclick="$IC.CALIBRATE_BIG_ACCEL_IN_BNO_MODE = !$IC.CALIBRATE_BIG_ACCEL_IN_BNO_MODE;" checked>calibrate big accel in BNO fusion mode&nbsp;<br>
        </span-->
        <!-- button onclick="console.log('accel', $IC._a, $IC._A);">MIKES TEST</button -->
      </div>
      <table id="status_table">
        <tr>
          <th>connected</th>
          <th>battery</th>
          <th>rssi</th>
          <th>data rate</th>
          <th>calibrated</th>
          <th>firmware</th>
          <th>api</th>
          <th>file</th>
        </tr>
        <tr>
          <td id="connection_state">DISCONNECTED</td>
          <td id="battery">0</td>
          <td id="signal_strength">-0</td>
          <td id="data_rate">0</td>
          <td id="calibrated">00000000</td>
          <td id="firmware">0.0</td>
          <td id="api">0.0</td>
          <td id="file"><?php echo($file_version); ?></td>
        </tr>       
      </table>
      <table id="calibration_error_table">
        <tr>
          <th>gyro &mu;</th>
          <th>gyro &sigma;<sup><small>2</small></sup></th>
          <th>acc &mu;</th>
          <th>acc &sigma;<sup><small>2</small></sup></th>
          <th>mag &mu;</th>
          <th>mag &sigma;<sup><small>2</small></sup></th>
          <th>r x</th>
          <th>r y</th>
          <th>r z</th>
        </tr>
        <tr>
          <td id="gyro_mu">0.000</td>
          <td id="gyro_sigma">0.000</td>
          <td id="acc_mu">0.000</td>
          <td id="acc_sigma">0.000</td>
          <td id="mag_mu">0.000</td>
          <td id="mag_sigma">0.000</td>
          <td id="ball_center_x">0</td>
          <td id="ball_center_y">0</td>
          <td id="ball_center_z">-0.1</td>          
        </tr>       
      </table>
<?php
}

function middle_of_page_crap()
{
?>
    </div><!--page_div-->
    <script language="javascript">
    
    var maxnum_lines  = 10000;
    var num_lines     = 0;
    
    window.onload = function()
    {
      msg('api', $IC.version);
      open_ball_input_source();
    }

    function msg(id, text)
    {
      document.getElementById(id).innerHTML = text;
    }
    
    var input_source = null;
    function play()
    {
      if(input_source != null)
        $IC.start_playing_data(input_source);
      else
        $IC.start_tracking();
        
      if(window.subclass_start != undefined)
        subclass_start();
      
      document.getElementById('play_button').style.display = 'none';
      document.getElementById('play_button_alt').style.display = 'inline-block';
    }
    
    function stop()
    {
      document.getElementById('play_button_alt').style.display = 'none';
      document.getElementById('play_button').style.display = 'inline-block';
  
      if(window.subclass_stop != undefined)
        subclass_stop();
        
      if($IC.is_tracking)
        $IC.stop_tracking();
      else
        $IC.pause_playing_data();
        
      if($IC.recording_is_armed)
        stop_record();
    }
    
    function rewind()
    {
      $IC.rewind_playing_data();
      display_timer_value(0);
    }
    
    function toggle_record()
    {
      if(!$IC.recording_is_armed)
        start_record();
      else
        stop_record();
    }

    function stop_record()
    {
      $IC.disarm_recording();
      document.getElementById('record_button_alt').style.display = 'none';
      document.getElementById('record_button').style.display = 'inline-block';
      show_save_data_modal();
    }
    
    function start_record()
    {
      if(input_source != null) return;
      $IC.arm_recording();
      document.getElementById('record_button').style.display = 'none';
      document.getElementById('record_button_alt').style.display = 'inline-block';
      if(!$IC.is_tracking) play();   
    }
    
    function toggle_fusion_mode(button)
    {
      var should_use_bno = (button.value == "TRUE");
      if(should_use_bno != $IC.USE_BNO_CALIBRATION_ORIENTATION)
        {
          var was_tracking = $IC.is_tracking;
          stop();
          $IC.USE_BNO_CALIBRATION_ORIENTATION = should_use_bno;
      
          if(was_tracking)
            play();
        }
    }
    
    function init_timer(for_playback)
    {
      var timer = document.getElementById('timer_table');
      if(for_playback)
        {
          timer.style.border = "1px solid green";
          timer.style.backgroundColor = "#EEFFEE";
          $IC.onplayback = timer_callback;
          $IC.onrecord = null;
        }
      else
        {
          timer.style.border = "1px solid red";
          timer.style.backgroundColor = "#FFEEEE";
          $IC.onplayback = null;
          $IC.onrecord = timer_callback;        
        }  
      display_timer_value(0);
    }
    
    function timer_callback(e)
    {
      if(!e.will_continue)
        {
          if(input_source == null)
            stop_record();
          else
            stop();
        }
      display_timer_value(e.running_duration);
    }
    
    function display_timer_value(value)
    {
      var secs = value.toFixed(0);
      var mins = Math.floor(secs / 60).toFixed(0);
      secs -= mins*60;
      secs = secs.toFixed(0);
      secs = "00".substr(secs.length) + secs;
      mins = "00".substr(mins.length) + mins;
      
      document.getElementById("record_timer_minutes").innerHTML = mins;
      document.getElementById("record_timer_seconds").innerHTML = secs;      
    }
    
    $IC.onconnection = function(e)
    {
      msg('connection_state', e.message);
    }

    $IC.onstatus = function(e)
    {
      msg('battery'        , e.volts.toFixed(2));
      msg('signal_strength', e.rssi.toFixed(2));
      //msg('calibrated'     , e.calibrated);
      msg('firmware'       , e.fwv);
    }

    $IC.oncalibratestatus = function(e)
    {
      msg('calibrated'     , e.cs        );
      msg('gyro_mu'        , e.gyro_mu.toFixed(6)   );   
      msg('gyro_sigma'     , e.gyro_sigma.toFixed(6)); 
      msg('acc_mu'         , e.acc_mu.toFixed(6)    ); 
      msg('acc_sigma'      , e.acc_sigma.toFixed(6) ); 
      msg('mag_mu'         , e.mag_mu.toFixed(6)    ); 
      msg('mag_sigma'      , e.mag_sigma.toFixed(6) ); 
    }
    
    $IC.ondatarate = function(e)
    {
      msg('data_rate', Math.round(1000 * e.sample_interval));
      //console.log(".");
      if((e.sample_interval > 1.5 * $IC._ic_interval) || (e.sample_interval < 0))
        {
          //console.log("ondatarate", e.sample_interval);
          //if(e.sample_interval > 0.100)
            //stop();
        }
    }
    
    $IC.onrevent = function(e)
    {
      msg("ball_center_x", e.x.toFixed(3) + " after " + e.nx + " samples");
      msg("ball_center_y", e.y.toFixed(3) + " after " + e.ny + " samples");
      msg("ball_center_z", e.z.toFixed(3) + " after " + e.nz + " samples");
    }
    
    function open_ball_input_source()
    {
      input_source=null;
      document.getElementById("show_input_sources") . innerHTML = "Input Source: Ball";
      stop();
      hide_input_sources_modal();
      init_timer(false);
    }

    function add_button(name, action)
    {
      var div    = document.getElementById("buttons");
      var button = document.createElement('button');
      button.onclick = action;
      button.innerHTML = name;
      div.appendChild(button);
    }

    var xmlhttp = new XMLHttpRequest();
    //xmlhttp.responseType = "text";
    xmlhttp.onreadystatechange = function() 
    {
      if(this.readyState == 4 && this.status == 200)
        {
          input_source = JSON.parse(pako.inflate(atob(this.response), {to:'string'}));
          stop();
          hide_input_sources_modal();
          document.getElementById("show_input_sources") . innerHTML = "Input Source: File";
          init_timer(true);
        }
    }
        
    function open_saved_json_input_source(unix_epoch)
    {
      var url = "../saved_data/" + unix_epoch + ".json.gzip";
      xmlhttp.open("GET", url, true);
      xmlhttp.send();
    }

    function delete_saved_data(redirect, unix_epoch, table_name, description)
    {
      if(!confirm("Are you sure you want to delete " + description + "?"))
        return;
  
      var f = document.createElement("form");      
      f.setAttribute("action", "/demo/_save_user_data.php");
      f.setAttribute("method", "post");
      f.style.display="none";
      f.innerHTML  = "<input type='hidden' name='action'     value='delete'>";
      f.innerHTML += "<input type='hidden' name='redirect'   value='"+ redirect   +"'>";
      f.innerHTML += "<input type='hidden' name='unix_epoch' value='"+ unix_epoch +"'>";
      f.innerHTML += "<input type='hidden' name='table_name' value='"+ table_name +"'>";
      f.innerHTML += "<input type='submit' value=''>";
      document.body.appendChild(f);
      f.submit();
    }

    function show_save_data_modal()
    {
      if($IC.recorded_data.length > 0)
        {
          var form = document.getElementById("save_data_form");
          form.uses_bno_calibration.value = ($IC.recorded_data[0].qw !== undefined);
          var saved_json_data = form.saved_json_data;
          var modal = document.getElementById("save_data_modal");
          saved_json_data.value = btoa(pako.gzip(JSON.stringify($IC.recorded_data), { level:6, to:'string' }));
          modal.style.display = "block";
        }
    }

    function view_json_data(unix_epoch)
    {
      var f = document.createElement("form");      
      f.setAttribute("action", "/demo/_view_json.php");
      f.setAttribute("method", "post");
      f.style.display="none";
      f.innerHTML  = "<input type='hidden' name='unix_epoch' value='"+ unix_epoch +"'>";
      f.innerHTML += "<input type='submit' value=''>";
      document.body.appendChild(f);
      f.submit();    
    }
    
    function log(row_value_vector)
    {
      if(num_lines < maxnum_lines)
        private_log(row_value_vector, 'td');
    }

    function log_clear_and_set_column_names(column_name_vector)
    {
      var table = document.getElementById('log_table');
      table.innerHTML = "";
      private_log(column_name_vector, 'th');
      num_lines = 0;
    }
    
    function private_log(m, type)
    {
      var table = document.getElementById('log_table');
      var tr  = document.createElement('tr');
  
      for(var i=0; i<m.length; i++)
        {
          var td = document.createElement(type);
          if(typeof(m[i]) == "number")
            m[i] = m[i].toFixed(4);
          td.innerHTML = m[i];
          tr.appendChild(td);
        }
      table.appendChild(tr);
  
      ++num_lines;
    }

    function hide_save_data_modal()
    {
      var save_data_modal = document.getElementById("save_data_modal");
      save_data_modal.style.display = "none";
      display_timer_value(0);
    }

    function show_input_sources_modal()
    {
      var modal = document.getElementById("input_sources_modal");
      modal.style.display = "block";      
    }

    function hide_input_sources_modal()
    {
      var modal = document.getElementById("input_sources_modal");
      modal.style.display = "none";      
    }
            
    window.onclick = function(event) 
    {
      if(event.target == document.getElementById("save_data_modal"))
        hide_save_data_modal();
      if(event.target == document.getElementById("input_sources_modal"))
        hide_input_sources_modal();
    }

<?php
}

function end_of_page_crap()
{
?>
    </script>
  </body>
</html>
<?php
}

?>
