<?php

$db = new SQLite3("saved_data/database.db");
  
if(validate_save_input($_POST))
  save($db, $_POST);
  
else if(validate_delete_input($_POST))
  delete($db, $_POST);

header("HTTP/1.1 303 See Other");
header("Location: " . $_POST['redirect']);
die;

/*--------------------------------------------------------------------*/
function save($db, $post)
{
  $table_name = $post['table_name'];
  $unix_epoch = time();
  $filename = $unix_epoch . ".json.gzip";
  
  //the calling page actually ensures that it exists, when it reads saved values so this is redundant...
  $db->exec("create table if not exists '". $table_name ."'(filename TEXT, unix_epoch TEXT, uses_bno_calibration TEXT, description TEXT, score TEXT);");
  
  $db->exec("insert into " . $table_name . " values('" . $filename . "', '" . $unix_epoch . "', '" . $post['uses_bno_calibration'] . "', '" . $post['description'] . "', '" . $post['score'] . "');");  
  file_put_contents ("saved_data/" . $filename, $post['saved_json_data']);
}

/*--------------------------------------------------------------------*/
function delete($db, $post)
{
  $table_name = $post['table_name'];
  $unix_epoch = $post['unix_epoch'];
  $filename = $unix_epoch . ".json.gzip";
  
  @$db->exec("delete from " . $table_name . " where unix_epoch = '" . $unix_epoch . "'");
  if(file_exists("saved_data/" . $filename))
    unlink("saved_data/" . $filename);
}

/*--------------------------------------------------------------------*/
function validate_delete_input(&$post)
{
  if(!isset($post['redirect']))             return false;
  if(!isset($post['unix_epoch']))           return false;
  if(!isset($post['table_name']))           return false;
  if(!isset($post['action']))               return false;
  if($post['action'] != 'delete')           return false;
  
  if(filter_var($post['unix_epoch'], FILTER_VALIDATE_INT) === false)
    return false;
  if(filter_var($post['redirect'], FILTER_VALIDATE_URL) === false)
    return false;
  if($post['table_name'] == "")
    return false;
  
  return true;
}

/*--------------------------------------------------------------------*/
function validate_save_input(&$post)
{
  if(!isset($post['description']))          return false;
  if(!isset($post['saved_json_data']))      return false;
  if(!isset($post['uses_bno_calibration'])) return false;
  if(!isset($post['redirect']))             return false;
  if(!isset($post['score']))                return false;
  if(!isset($post['table_name']))           return false;
  if(!isset($post['action']))               return false;
  if($post['action'] != 'save')             return false;
  
  $post['description'] = htmlspecialchars(trim(strip_tags($post['description'])));
  //if($post['description'] === "")
    //return false;
    
  //$post['saved_json_data'] = gzdecode(base64_decode($post['saved_json_data']));
  //json_decode($post['saved_json_data']);
  //if(json_last_error() != JSON_ERROR_NONE)
    //return false;
    
  //todo: this should be the string 'true' or 'false'. This function should return false if other values are present.
  //if(filter_var($post['uses_bno_calibration'], FILTER_VALIDATE_BOOLEAN) === false)
    //return false;
    
  if(filter_var($post['redirect'], FILTER_VALIDATE_URL) === false)
    return false;
  if($post['table_name'] == "")
    return false;

  //validate score?
  
  return true;
}