%% set all the necessary stuff
clear

tracker.name = 'Tracking-Learning-Detection';
tracker.short = 'TLD';
tracker.url = 'http://personal.ee.surrey.ac.uk/Personal/Z.Kalal/tld.html';
tracker.is3D = false;

sequences = {'doughnut', 'rally-audi', 'rally-lancer', 'rally-opel', 'rally-ots', 'rally-vw', 'topGear01', 'topGear02'};
numSeq = length(sequences);


%% load all the sequences

trackerResults = cell(1, numSeq);
GT = cell(1, numSeq);
for i = 1:numSeq
	trackerResults{i} = dlmread([sequences{i} '_' tracker.short '.txt']);
	GT{i} = dlmread([sequences{i} '_gt.txt']);
end

%% compute the distances

meanDists = zeros(1, numSeq+1);
for i = 1:numSeq
	trackedCentre = trackerResults{i}(:,1:2) + 0.5*trackerResults{i}(:,3:4);
	gtCentre = GT{i}(:,1:2) + 0.5*GT{i}(:,3:4);
	dist = sqrt(sum( (trackedCentre - gtCentre).^2, 2));
	dist(isnan(dist)) = max(dist);
	meanDists(i) = mean(dist);
end

meanDists(end) = mean(meanDists(1:end-1))


%% compute the overlaps
% this is valid only for axis-aligned bounding boxes, if your tracker provides oriented bounding
% box, please change this code accordingly and let us know when submitting

meanOverlaps = zeros(1, numSeq+1);
for i = 1:numSeq
	overlaps = zeros(1, size(GT{i},1));
	for j = 1:size(GT{i},1)
		trackedBB = trackerResults{i}(j,:);
		gtBB = GT{i}(j,:);
		if any(isnan(trackedBB))
			overlaps(j) = 0;
			continue;
		end
		% intersection
		xData = sort([trackedBB(1) trackedBB(1)+trackedBB(3) gtBB(1) gtBB(1)+gtBB(3)]);
		yData = sort([trackedBB(2) trackedBB(2)+trackedBB(4) gtBB(2) gtBB(2)+gtBB(4)]);
		intersection = max(0, xData(3)-xData(2)) * max(0, yData(3)-yData(2));
		% overlap = inters/union = inters / (one + other - inters)
		overlaps(j) = intersection / (trackedBB(3)*trackedBB(4) + gtBB(3)*gtBB(4) - intersection);
	end
	meanOverlaps(i) = mean(overlaps);
end

meanOverlaps(end) = mean(meanOverlaps(1:end-1))

%% print it out

fprintf('Tracker long name: %s\n', tracker.name);
fprintf('Tracker short name: %s\n', tracker.short);
fprintf('Tracker url: %s\n', tracker.url);
if tracker.is3D
	fprintf('Tracker is 3D: YES\n');
else
	fprintf('Tracker is 3D: NO\n');
end

fprintf('\n');

for i = 1:numSeq
	fprintf('Results on sequence %s: %.1f / %.1f\n', sequences{i}, meanDists(i), meanOverlaps(i)*100);
end

fprintf('Average results: %.1f / %.1f\n', meanDists(end), meanOverlaps(end)*100);

%% print it in a file

fOut = fopen(['_results_' tracker.short '.txt'], 'w');

fprintf(fOut, 'Tracker long name: %s\n', tracker.name);
fprintf(fOut, 'Tracker short name: %s\n', tracker.short);
fprintf(fOut, 'Tracker url: %s\n', tracker.url);
if tracker.is3D
	fprintf(fOut, 'Tracker is 3D: YES\n');
else
	fprintf(fOut, 'Tracker is 3D: NO\n');
end

fprintf(fOut, '\n');

for i = 1:numSeq
	fprintf(fOut, 'Results on sequence %s: %.1f / %.1f\n', sequences{i}, meanDists(i), meanOverlaps(i)*100);
end

fprintf(fOut, 'Average results: %.1f / %.1f\n', meanDists(end), meanOverlaps(end)*100);

fclose(fOut);

