__author__ = 'Konstantin_Brand'

from pylab import *
import DCTo
import DSTo

def optimfuncDSTDCTL1randsamp(x):
    ''' function to minimize, dim. of x is 32
    x is the sparse vector of unknown (DCT and DST) doefficients.
    Example of matching pursiut and random sampling, overcomplete transform with DCT and DST and L1 (abs) norm.
    Args:    x: (ndarray)
    Return:  optimfuncDSTDCTL1randsamp: (ndarray)
    '''
    # Overcomplete transform:
    t = hstack((DCTo(16), DSTo(16)))
    # Signal Example:
    s = cos(pi/16*(arange(16))*12.5)
    # random sampling with a constant pattern:
    seed([1, 2, 3])
    r = rand(16, 1)
    # only a fraction of 0.25 is randomly sampled, hence below Nyquist!:
    randpat = r < 0.6
    randpat.astype(int)
    # Lagrange optimization, with distance measure only for random samples:
    optimfuncDSTDCTL1randsamp = sum(((s-dot(t, x))*randpat)**2)+sum(abs(x))
    return optimfuncDSTDCTL1randsamp
