from pylab import *
import sound as snd

x, Fs=snd.wavread('fspeech.wav');#read in speech sound file in x, sample rate in Fs
x=array(x,dtype=float)/(2**15)   #normalize to range -1...+1
noise=(rand(len(x))-0.5)*0.1     #uniform zero mean noise samples
x=x+noise			 #add noise to speech
plot(x);xlabel('Time, Sample No.');ylabel('Sample Value');title("Noisy Speech");show()
snd.sound(x*2**15, 32000)	 #play de-normalized noisy speech sound
e=zeros(len(x));		 #initialize
p=zeros(len(x));
h=zeros(10);			 #10 weights for prediction

for n in range(10,len(x)):	 #for loop over sound file
  p[n]=dot(x[n-10:n], flipud(h)) #prediction using the adapted weights
  e[n]=x[n] - p[n] 		 #prediction error
  h= h + 1.0 *e[n]*flipud(x[n-10:n]); #LMS update rule, alpha=1.0

#Plot and play out the prediction error and de-normalize:
plot(e,'r');title("Prediction Error");show()
snd.sound(e*2**15, Fs)
#Plot and play out the predicted signal:
plot(p);title("De-Noised Speech"); show()
snd.sound(p*2**15, Fs)
